package com.liquidnet.service.kylin.controller;

import com.liquidnet.service.kylin.service.impl.OrderRefundOvertimeServiceImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * <p>
 * 退款回掉
 * </p>
 *
 * @author jiangxiulong
 * @since 2021-06-11 6:10 下午
 */
@Api(tags = "前端-退款回调")
@RestController
@RequestMapping("refund")
public class OrderRefundOvertimeController {

    @Autowired
    private OrderRefundOvertimeServiceImpl orderRefundOvertimeServiceImpl;

    @PostMapping("apply")
    @ApiOperation("超时退款")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "body", dataType = "String", name = "orderTicketsId", value = "订单ID", required = true),
    })
    public Boolean refundApply(@RequestParam() String orderTicketsId) {
        try {
            Boolean res = orderRefundOvertimeServiceImpl.refundApply(orderTicketsId);
            if (res) {
                return true;
            } else {
                return false;
            }
        } catch (Exception e) {
            return false;
        }
    }

}
