package com.liquidnet.service.kylin.controller.admin;


import com.github.pagehelper.PageInfo;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.kylin.dao.PerformanceAdminListDao;
import com.liquidnet.service.kylin.dao.PerformanceMemberAuditDao;
import com.liquidnet.service.kylin.dao.PerformanceRecommendAdminDao;
import com.liquidnet.service.kylin.dao.PerformanceTitleDao;
import com.liquidnet.service.kylin.dto.param.PerformanceAdminListParam;
import com.liquidnet.service.kylin.dto.param.PerformanceMemberAuditParam;
import com.liquidnet.service.kylin.dto.param.PerformanceRecommendAdminParam;
import com.liquidnet.service.kylin.dto.vo.partner.PerformanceMisVo;
import com.liquidnet.service.kylin.service.impl.admin.KylinPerformancesAdminServiceImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * <p>
 * 演出 前端控制器
 * </p>
 *
 * @author liquidnet
 * @since 2021-05-05
 */
@Api(tags = "后端-演出", position = 2001)
@RestController
@RequestMapping("admin/performance")
public class KylinPerformancesAdminController {

    @Autowired
    private KylinPerformancesAdminServiceImpl performancesAdminService;

    @PostMapping(value = "list")
    @ApiOperation(value = "获取列表", position = 1)
    @ApiResponse(response = PerformanceAdminListDao.class, code = 200, message = "接口返回对象参数")
    public ResponseDto<PageInfo<PerformanceAdminListDao>> getList(@RequestBody @Valid PerformanceAdminListParam performanceAdminListParam) {
        PageInfo<PerformanceAdminListDao> result = null;
        result = performancesAdminService.getList(performanceAdminListParam);
        if (null != result) {
            return ResponseDto.success(result);
        } else {
            return ResponseDto.failure("获取演出详情失败");
        }
    }

    @GetMapping(value = "details")
    @ApiOperation(value = "获取演出详情", position = 2)
    @ApiResponse(response = PerformanceMisVo.class, code = 200, message = "接口返回对象参数")
    public ResponseDto<PerformanceMisVo> performanceDetails(@RequestParam("performancesId") String performancesId) {
        PerformanceMisVo result = null;
        result = performancesAdminService.performanceDetails(performancesId);
        if (null != result) {
            return ResponseDto.success(result);
        } else {
            return ResponseDto.failure("获取演出详情失败");
        }
    }

    @PostMapping(value = "audit")
    @ApiOperation(value = "演出审核", position = 3)
    @ApiResponse(code = 200, message = "接口返回对象参数")
    public ResponseDto<String> performanceAudit(@RequestParam("performancesId") String performancesId, @RequestParam("status") int status, @RequestParam(value = "rejectTxt", required = false) String rejectTxt) {
        boolean result = performancesAdminService.performanceAudit(performancesId, status, rejectTxt);
        if (result) {
            return ResponseDto.success("审核完成");
        } else {
            return ResponseDto.failure("审核失败");
        }
    }

    @GetMapping(value = "list/roadshow")
    @ApiOperation(value = "列表根据巡演id", position = 4)
    @ApiResponse(code = 200, message = "接口返回对象参数")
    public ResponseDto<List<PerformanceTitleDao>> getListByRoadShowId(@RequestParam("roadShowId") String roadShowId) {
        List<PerformanceTitleDao> result = performancesAdminService.getListByRoadShowId(roadShowId);
        if (result.size() > 0) {
            return ResponseDto.success(result);
        } else {
            return ResponseDto.failure("查询失败");
        }
    }

    @GetMapping(value = "list/status")
    @ApiOperation(value = "列表根据演出状态", position = 5)
    @ApiResponse(code = 200, message = "接口返回对象参数")
    public ResponseDto<List<PerformanceTitleDao>> getListByStatus(@RequestParam("status") String status) {
        List<PerformanceTitleDao> result = performancesAdminService.getListByStatus(status);
        if (result.size() > 0) {
            return ResponseDto.success(result);
        } else {
            return ResponseDto.failure("查询失败");
        }
    }

    @GetMapping(value = "roadShow/relation")
    @ApiOperation(value = "修改演出巡演关联", position = 6)
    @ApiResponse(code = 200, message = "接口返回对象参数")
    public ResponseDto<String> changeRoadShowId(@RequestParam("performanceId") String performanceId, @RequestParam("roadShowId") String roadShowId) {
        boolean result = performancesAdminService.changeRoadShowId(performanceId, roadShowId);
        if (result) {
            return ResponseDto.success("操作成功");
        } else {
            return ResponseDto.failure("操作失败");
        }
    }

    @PutMapping(value = "recommend")
    @ApiOperation(value = "演出推荐编辑", position = 7)
    @ApiResponse(code = 200, message = "接口返回对象参数")
    public ResponseDto<String> setRecommend(@RequestBody @Valid List<PerformanceRecommendAdminParam> performanceRecommendAdminParam) {
        boolean result = performancesAdminService.setRecommend(performanceRecommendAdminParam);
        if (result) {
            return ResponseDto.success("操作成功");
        } else {
            return ResponseDto.failure("操作失败");
        }
    }

    @GetMapping(value = "recommend/list")
    @ApiOperation(value = "演出推荐列表", position = 8)
    @ApiResponse(code = 200, message = "接口返回对象参数")
    public ResponseDto<PageInfo<PerformanceRecommendAdminDao>> listRecommend() {
        PageInfo<PerformanceRecommendAdminDao> result = performancesAdminService.listRecommend();
        if (result != null) {
            return ResponseDto.success(result);
        } else {
            return ResponseDto.failure("获取失败");
        }
    }

    @GetMapping(value = "member/details")
    @ApiOperation(value = "演出会员信息", position = 9)
    @ApiResponse(code = 200, message = "接口返回对象参数")
    public ResponseDto<PerformanceMemberAuditDao> performanceMemberInfo(@RequestParam("performanceId") @NotNull String performanceId) {
        PerformanceMemberAuditDao result = performancesAdminService.performanceMemberInfo(performanceId);
        if (result != null) {
            return ResponseDto.success(result);
        } else {
            return ResponseDto.failure("获取失败");
        }
    }

    @PutMapping(value = "member/change")
    @ApiOperation(value = "修改演出会员数据", position = 10)
    @ApiResponse(code = 200, message = "接口返回对象参数")
    public ResponseDto<String> performanceMemberChange(@RequestBody PerformanceMemberAuditParam performanceMemberAuditParam) {
        boolean result = performancesAdminService.performanceMemberChange(performanceMemberAuditParam);
        if (result) {
            return ResponseDto.success("操作成功");
        } else {
            return ResponseDto.failure("操作失败");
        }
    }

    @GetMapping(value = "member/list")
    @ApiOperation(value = "待审核会员演出列表", position = 11)
    @ApiResponse(code = 200, message = "接口返回对象参数")
    public ResponseDto<PageInfo<PerformanceTitleDao>> performanceMemberList(@RequestParam(value = "title" , required=false) String title,
                                                                            @RequestParam("page") @NotNull int page,
                                                                            @RequestParam("size") @NotNull int size) {
        PageInfo<PerformanceTitleDao> result = performancesAdminService.performanceMemberList(title, page, size);
        if (result != null) {
            return ResponseDto.success(result);
        } else {
            return ResponseDto.failure("操作失败");
        }
    }

    @GetMapping(value = "member/details/audit")
    @ApiOperation(value = "演出会员信息(根据status 1待审核 2已拒绝 3已通过)", position = 12)
    @ApiResponse(code = 200, message = "接口返回对象参数")
    public ResponseDto<PerformanceMemberAuditDao> performanceMemberAuditInfo(@RequestParam("performanceId") @NotNull String performanceId,
                                                                             @RequestParam(value = "status") @NotNull int status) {
        PerformanceMemberAuditDao result = performancesAdminService.performanceMemberAuditInfo(performanceId, status);
        if (result != null) {
            return ResponseDto.success(result);
        } else {
            return ResponseDto.failure("获取失败");
        }
    }

    @PostMapping(value = "member/audit")
    @ApiOperation(value = "审核演出会员信息", position = 13)
    @ApiResponse(code = 200, message = "接口返回对象参数")
    public ResponseDto<String> performanceMemberAudit(@RequestParam("performanceId") @NotNull String performanceId,
                                                      @RequestParam("status") @NotNull int status,
                                                      @RequestParam(value = "rejectTxt", required = false) String rejectTxt) {
        boolean result = performancesAdminService.performanceMemberAudit(performanceId, status, rejectTxt);
        if (result) {
            return ResponseDto.success("操作成功");
        } else {
            return ResponseDto.failure("操作失败");
        }
    }

    @PostMapping(value = "member/history")
    @ApiOperation(value = "会员审核记录")
    @ApiResponse(code = 200, message = "接口返回对象参数")
    public ResponseDto<PageInfo<PerformanceMemberAuditParam>> performanceAuditHistory(@RequestParam("performanceId") @NotNull String performanceId) {
        PageInfo<PerformanceMemberAuditParam> result = performancesAdminService.performanceAuditHistory(performanceId);
        if (result != null) {
            return ResponseDto.success(result);
        } else {
            return ResponseDto.failure("操作失败");
        }
    }

    @PostMapping(value = "ticket/agent")
    @ApiOperation(value = "修改票分销状态")
    @ApiResponse(code = 200, message = "接口返回对象参数")
    public ResponseDto<String> changeTicketAgent(@RequestParam("ticketId") @NotNull String ticketId, @RequestParam("status") @NotNull Integer status) {
        boolean result = performancesAdminService.changeTicketAgent(ticketId, status);
        if (result) {
            return ResponseDto.success("修改完成");
        } else {
            return ResponseDto.failure("操作失败");
        }
    }
}
