package com.liquidnet.service.kylin.dto.vo.mongo;

import com.liquidnet.service.kylin.dto.vo.returns.OrderRefundListVo;
import com.liquidnet.service.kylin.entity.KylinOrderTicketRelations;
import com.liquidnet.service.kylin.entity.KylinOrderTicketStatus;
import com.liquidnet.service.kylin.entity.KylinOrderTickets;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.beans.BeanUtils;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

@ApiModel(value = "KylinOrderTicketVo", description = "订单数据")
@Data
public class KylinOrderTicketVo implements Serializable, Cloneable {
    private Integer mid;
    private static final long serialVersionUID = 5325511589667456213L;
    @ApiModelProperty(position = 10, value = "ID")
    private String orderTicketsId;
    @ApiModelProperty(position = 11, value = "用户ID[64]")
    private String userId;
    @ApiModelProperty(position = 12, value = "用户昵称")
    private String userName;
    @ApiModelProperty(position = 13, value = "用户手机号")
    private String userMobile;
    @ApiModelProperty(position = 14, value = "演出名称")
    private String performanceTitle;
    @ApiModelProperty(position = 15, value = "票种名称")
    private String ticketTitle;
    @ApiModelProperty(position = 15, value = "开始时间")
    private String timeStart;
    @ApiModelProperty(position = 15, value = "适用时间")
    private String useStart;
    @ApiModelProperty(position = 15, value = "演出图片")
    private String performanceImg;
    @ApiModelProperty(position = 15, value = "订单号")
    private String orderCode;
    @ApiModelProperty(position = 16, value = "支付单号")
    private String payCode;
    @ApiModelProperty(position = 17, value = "二维码地址")
    private String qrCode;
    @ApiModelProperty(position = 18, value = "下单方式")
    private String orderType;
    @ApiModelProperty(position = 19, value = "下单版本")
    private String orderVersion;
    @ApiModelProperty(position = 20, value = "数量")
    private Integer number;
    @ApiModelProperty(position = 21, value = "单价")
    private BigDecimal price;
    @ApiModelProperty(position = 22, value = "会员单价")
    private BigDecimal priceMember;
    @ApiModelProperty(position = 23, value = "应付价格")
    private BigDecimal priceTotal;
    @ApiModelProperty(position = 24, value = "优惠价格")
    private BigDecimal priceVoucher;
    @ApiModelProperty(position = 25, value = "实付价格")
    private BigDecimal priceActual;
    @ApiModelProperty(position = 26, value = "快递价格")
    private BigDecimal priceExpress;
    @ApiModelProperty(position = 27, value = "退款价格")
    private BigDecimal priceRefund;
    @ApiModelProperty(position = 28, value = "退款张数")
    private Integer refundNumber;
    @ApiModelProperty(position = 29, value = "选择支付方式")
    private String payType;
    @ApiModelProperty(position = 30, value = "实际支付方式")
    private String paymentType;
    @ApiModelProperty(position = 31, value = "支付时间")
    private String timePay;
    @ApiModelProperty(position = 32, value = "收货人")
    private String expressContacts;
    @ApiModelProperty(position = 33, value = "收货地址")
    private String expressAddress;
    @ApiModelProperty(position = 34, value = "收货人联系方式")
    private String expressPhone;
    @ApiModelProperty(position = 35, value = "券使用类别")
    private String couponType;
    @ApiModelProperty(position = 36, value = "取票方式 电子票electronic快递票express")
    private String getTicketType;
    @ApiModelProperty(position = 37, value = "直播用取票观演码，隔开")
    private String getTicketDescribe;
    @ApiModelProperty(position = 38, value = "订单过期时间(分钟)")
    private Integer payCountdownMinute;
    @ApiModelProperty(position = 15, value = "快递方式")
    private Integer expressType;
    @ApiModelProperty(position = 15, value = "是否学生票")
    private Integer isStudent;
    @ApiModelProperty(position = 15, value = "转赠状态")
    private Integer transferStatus;
    @ApiModelProperty(position = 15, value = "订单状态[订单状态:0待付款，1已付款，2已关闭，3正在退款，4已退款, 5待关闭 6部分退款]")
    private Integer status;
    @ApiModelProperty(position = 15, value = "支付状态[支付状态:0未支付 1已支付 2支付失败]")
    private Integer payStatus;
    @ApiModelProperty(position = 15, value = "转赠订单id")
    private String transferId;
    @ApiModelProperty(position = 15, value = "转赠用户id")
    private String transferUid;
    @ApiModelProperty(position = 15, value = "直播id")
    private String liveId;
    @ApiModelProperty(position = 15, value = "演出id")
    private String performanceId;
    @ApiModelProperty(position = 15, value = "场次id")
    private String timeId;
    @ApiModelProperty(position = 15, value = "票种id")
    private String ticketId;
    @ApiModelProperty(position = 15, value = "代理id")
    private String agentId;
    @ApiModelProperty(position = 15, value = "是否会员")
    private Integer isMember;
    @ApiModelProperty(position = 15, value = "订单过期日期")
    private String overdueAt;
    @ApiModelProperty(position = 15, value = "创建时间")
    private String createdAt;
    @ApiModelProperty(position = 15, value = "更新时间")
    private String updatedAt;

    //    private Integer isCanRefund;
    @ApiModelProperty(position = 15, value = "退款相关列表")
    private List<OrderRefundListVo> orderRefundListVos;

    private LocalDateTime changeDate;

    @ApiModelProperty(position = 15, value = "是否实名")
    private Integer isTrueName;
    @ApiModelProperty(position = 15, value = "购票须知")
    private String noticeImage;
    private String notice;
    @ApiModelProperty(position = 15, value = "票种类型")
    private Integer ticketType;
    @ApiModelProperty(position = 15, value = "演出名称")
    private String fieldName;
    @ApiModelProperty(position = 20, value = "转赠时间")
    private String transferTime;
    @ApiModelProperty(position = 15, value = "票单列表")
    private List<KylinOrderTicketEntitiesVo> entitiesVoList;

    public void setTransferTime(String transferTime) {
        this.transferTime = transferTime==null?"":transferTime;
    }

    public String getTransferTime() {
        return transferTime==null?"":transferTime;
    }

    public void setOrderTicket(KylinOrderTickets orderTicket) {
        BeanUtils.copyProperties(orderTicket, this);
    }

    public void setOrderTicketStatus(KylinOrderTicketStatus orderTicketStatus) {
        BeanUtils.copyProperties(orderTicketStatus, this);
    }

    public void setOrderTicketRelation(KylinOrderTicketRelations orderTicketRelation) {
        BeanUtils.copyProperties(orderTicketRelation, this);
    }

    private static final KylinOrderTicketVo obj = new KylinOrderTicketVo();

    public static KylinOrderTicketVo getNew() {
        try {
            return (KylinOrderTicketVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new KylinOrderTicketVo();
        }
    }
}
