/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.api.internal.toplink.channel.netty;

import com.taobao.api.internal.toplink.LoggerFactory;
import com.taobao.api.internal.toplink.Text;
import com.taobao.api.internal.toplink.channel.ServerChannel;
import com.taobao.api.internal.toplink.channel.netty.MaxIdleTimeHandler;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import org.jboss.netty.bootstrap.ServerBootstrap;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.group.ChannelGroup;
import org.jboss.netty.channel.group.DefaultChannelGroup;
import org.jboss.netty.channel.socket.nio.NioServerSocketChannelFactory;
import org.jboss.netty.handler.ssl.SslHandler;
import org.jboss.netty.handler.timeout.IdleStateHandler;
import org.jboss.netty.util.HashedWheelTimer;
import org.jboss.netty.util.Timer;

public abstract class NettyServerChannel
extends ServerChannel {
    private static NioServerSocketChannelFactory nioServerSocketChannelFactory = new NioServerSocketChannelFactory((Executor)Executors.newCachedThreadPool(), (Executor)Executors.newCachedThreadPool());
    private ServerBootstrap bootstrap;
    protected ChannelGroup allChannels = new DefaultChannelGroup();
    protected SSLContext sslContext;

    public NettyServerChannel(LoggerFactory factory, int port) {
        super(factory, port);
    }

    public void setSSLContext(SSLContext sslContext) {
        this.sslContext = sslContext;
    }

    public void run() {
        this.bootstrap = new ServerBootstrap((ChannelFactory)nioServerSocketChannelFactory);
        this.bootstrap.setOption("reuseAddress", (Object)true);
        this.bootstrap.setOption("backlog", (Object)1024);
        this.bootstrap.setOption("sendBufferSize", (Object)0x100000);
        this.bootstrap.setOption("receiveBufferSize", (Object)0x100000);
        this.bootstrap.setOption("child.sendBufferSize", (Object)0x100000);
        this.bootstrap.setOption("child.receiveBufferSize", (Object)0x100000);
        this.bootstrap.setOption("child.tcpNoDelay", (Object)true);
        this.prepareBootstrap(this.bootstrap);
        HashedWheelTimer timer = new HashedWheelTimer();
        this.bootstrap.setPipelineFactory(new ChannelPipelineFactory((Timer)timer){
            final /* synthetic */ Timer val$timer;
            {
                this.val$timer = timer;
            }

            public ChannelPipeline getPipeline() throws Exception {
                ChannelPipeline pipeline = Channels.pipeline();
                if (NettyServerChannel.this.maxIdleTimeSeconds > 0) {
                    pipeline.addLast("idleStateHandler", (ChannelHandler)new IdleStateHandler(this.val$timer, 0, 0, NettyServerChannel.this.maxIdleTimeSeconds));
                    pipeline.addLast("maxIdleHandler", (ChannelHandler)new MaxIdleTimeHandler(NettyServerChannel.this.loggerFactory, NettyServerChannel.this.maxIdleTimeSeconds));
                }
                if (NettyServerChannel.this.sslContext != null) {
                    SSLEngine sslEngine = NettyServerChannel.this.sslContext.createSSLEngine();
                    sslEngine.setUseClientMode(false);
                    pipeline.addLast("ssl", (ChannelHandler)new SslHandler(sslEngine));
                }
                NettyServerChannel.this.preparePipeline(pipeline);
                return pipeline;
            }
        });
        this.allChannels.add((Object)this.bootstrap.bind((SocketAddress)new InetSocketAddress(this.port)));
        this.logger.info(Text.SERVER_RUN, this.port);
    }

    public void stop() {
        this.allChannels.close().awaitUninterruptibly();
        this.logger.info(Text.SERVER_STOP);
    }

    protected abstract void preparePipeline(ChannelPipeline var1);

    protected void prepareBootstrap(ServerBootstrap bootstrap) {
    }
}

