package com.liquidnet.service.candy.vo;

import com.liquidnet.service.candy.dto.CandyCouponRuleDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.apache.commons.lang3.ObjectUtils;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

@Data
@ApiModel
public class CandyCouponVo implements Serializable, Cloneable {

    private static final long serialVersionUID = 4073256621782131606L;

    /* --- --- --- CandyCoupon */
    @ApiModelProperty(value = "标题",example = "标题")
    private String title;
    @ApiModelProperty(value = "标注",example = "标注")
    private String label;
    @ApiModelProperty(value = "须知",example = "须知")
    private String notice;
    //    private Integer exclusive;//专享标识[0-常规｜1-会员礼包]
    @ApiModelProperty(value = "业务类别[0-全场｜1-演出｜2-商品｜3-优先购]",example = "0")
    private Integer busiType;
    @ApiModelProperty(value = "券类型[1-代金券｜2-满减券｜3-兑换券｜4-折扣券]",example = "1")
    private Integer couType;
    @ApiModelProperty(value = "[0-用户输入兑换｜1-发放至用户]",example = "1")
    private Integer bindType;
    @ApiModelProperty(value = "折扣 可null",example = "0.5")
    private BigDecimal discount;
    @ApiModelProperty(value = "面值 可null",example = "1")
    private BigDecimal valFace;
    @ApiModelProperty(value = "满减~满 可null",example = "100")
    private BigDecimal valOver;
    @ApiModelProperty(value = "满减~减少 可null",example = "5")
    private BigDecimal valMinus;
    @ApiModelProperty(value = "过期时间 可null",example = "2021-09-25")
    private String expireAt;

    /* --- --- --- CandyUserCoupon */
    @ApiModelProperty(value = "券id",example = "6d74a49d3d1d13f96ba09215abcc49af")
    private String ucouponId;
    @ApiModelProperty(value = "券状态[1-可用|2-无效｜3-已过期｜5-已使用 |21-不可用]",example = "1")
    private Integer state;
    //    private String bindAt;//激活时间
    @ApiModelProperty(value = "使用时间 可null",example = "2021-09-25")
    private String usedAt;
    @ApiModelProperty(value = "购买内容 可null",example = "北京草莓")
    private String usedFor;


    /* --- --- --- CandyCouponRule */
    private List<CandyCouponRulesVo> useRules;

    private static final CandyCouponVo obj = new CandyCouponVo();

    public static CandyCouponVo getNew() {
        try {
            return (CandyCouponVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        return new CandyCouponVo();
    }

}
