package com.liquidnet.service.candy.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

@Data
@ApiModel
public class CandyUseResultVo implements Serializable, Cloneable {

    private static final long serialVersionUID = 4073256621782131607L;
    @ApiModelProperty(value = "优惠内容",example = "1")
    private BigDecimal value;
    @ApiModelProperty(value = "券类型[1-代金券｜2-满减券｜3-兑换券｜4-折扣券]",example = "1")
    private Integer couType;

    private static final CandyUseResultVo obj = new CandyUseResultVo();

    public static CandyUseResultVo getNew() {
        try {
            return (CandyUseResultVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        return new CandyUseResultVo();
    }

}
