package com.liquidnet.service.kylin.dto.param;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.liquidnet.commons.lang.util.IDGenerator;
import com.liquidnet.service.kylin.entity.KylinFieldRelations;
import com.liquidnet.service.kylin.entity.KylinFieldStatus;
import com.liquidnet.service.kylin.entity.KylinFields;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.beans.BeanUtils;

import java.io.Serializable;
import java.time.LocalDateTime;


/**
 * 修改场地全部显示数据参数
 */
@Data
public class FieldsSearchParam implements Serializable {
    @ApiModelProperty(value = "场地名称", example = "")
    private String name;

    @ApiModelProperty(value = "省名称", example = "")
    private String provinceName;

    @ApiModelProperty(value = "城市名称", example = "")
    private String cityName;

    @ApiModelProperty(value = "县名称", example = "")
    private String districtName;

    @ApiModelProperty(value = "认证状态 -1全部 0未认证 1已认证", example = "-1")
    private int validStatus;

    @ApiModelProperty(value = "是否显示 -1全部 0不显示 1显示", example = "-1")
    private int isDisplay;

    @ApiModelProperty(value = "是否营业 -1全部 0不营业 1营业中", example = "-1")
    private int isBusiness;

    @ApiModelProperty(value = "审核状态 -1全部 0待审核 1已审核 2被拒绝", example = "-1")
    private int changeStatus;

    @ApiModelProperty(value = "排序类型 1创建时间 1修改时间 ", example = "1")
    private int orderType;

    @ApiModelProperty(value = "页数 ", example = "1")
    private int page;

    @ApiModelProperty(value = "数量 ", example = "10")
    private int size;

    @JsonIgnore
    private int provinceId;

    @JsonIgnore
    private int cityId;

    @JsonIgnore
    private int districtId;
}
