package com.liquidnet.service.account.wallet.dto;

import com.liquidnet.service.account.common.FinConstants;
import com.liquidnet.service.account.wallet.dto.base.WalletCallParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * WalletTransactionParam.class
 *
 * @author zhanggb
 * Created by IntelliJ IDEA at 2020/10/23
 */
@ApiModel(value = "WalletTransactionParam", description = "Parameters of wallet transaction")
public class WalletTransactionParam extends WalletCallParam {
    private static final long serialVersionUID = -1863820554930037114L;
    @ApiModelProperty(position = 11, required = true, value = "Wallet number [11]")
    private String walletNo;
    @ApiModelProperty(position = 12, required = true, value = "Wallet transaction type")
    private FinConstants.TransType transType;
    @ApiModelProperty(position = 13, required = true, value = "Transaction amount [20,6]")
    private BigDecimal amount;
    @ApiModelProperty(position = 14, required = true, value = "Transaction type [30]")
    private String tracingType;
    @ApiModelProperty(position = 15, required = true, value = "Transaction ID [64]")
    private String tracingNo;
    @ApiModelProperty(position = 16, required = true, value = "Transaction time")
    private LocalDateTime tracingTime;
    @ApiModelProperty(position = 17, required = true, value = "Transaction title [100]")
    private String tracingTitle;
    @ApiModelProperty(position = 18, required = false, value = "Transaction desc [100]")
    private String tracingDesc;

    public String getWalletNo() {
        return walletNo;
    }

    public void setWalletNo(String walletNo) {
        this.walletNo = walletNo;
    }

    public FinConstants.TransType getTransType() {
        return transType;
    }

    public void setTransType(FinConstants.TransType transType) {
        this.transType = transType;
    }

    public BigDecimal getAmount() {
        return amount;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public String getTracingType() {
        return tracingType;
    }

    public void setTracingType(String tracingType) {
        this.tracingType = tracingType;
    }

    public String getTracingNo() {
        return tracingNo;
    }

    public void setTracingNo(String tracingNo) {
        this.tracingNo = tracingNo;
    }

    public LocalDateTime getTracingTime() {
        return tracingTime;
    }

    public void setTracingTime(LocalDateTime tracingTime) {
        this.tracingTime = tracingTime;
    }

    public String getTracingTitle() {
        return tracingTitle;
    }

    public void setTracingTitle(String tracingTitle) {
        this.tracingTitle = tracingTitle;
    }

    public String getTracingDesc() {
        return tracingDesc;
    }

    public void setTracingDesc(String tracingDesc) {
        this.tracingDesc = tracingDesc;
    }
}
