package com.liquidnet.service.sweet.controller;


import com.github.pagehelper.PageInfo;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.sweet.entity.SweetArtists;
import com.liquidnet.service.sweet.entity.SweetStage;
import com.liquidnet.service.sweet.service.ISweetArtistsService;
import com.liquidnet.service.sweet.service.ISweetStageService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * <p>
 * 艺人表 前端控制器
 * </p>
 *
 * @author liquidnet
 * @since 2021-07-23
 */
@Api(tags = "艺人")
@RestController
@RequestMapping("/sweet-artists")
public class SweetArtistsController {

    @Autowired
    ISweetArtistsService sweetArtistsService;

    @GetMapping("list")
    @ApiOperation("艺人列表")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "query", dataType = "Integer", name = "page", value = "页数", required = true),
            @ApiImplicitParam(type = "query", dataType = "Integer", name = "size", value = "数量", required = true),
            @ApiImplicitParam(type = "query", dataType = "String", name = "name", value = "艺人姓名 不查询从传递null", required = false),
    })
    public ResponseDto<PageInfo<SweetArtists>> getList(@RequestParam() Integer page,
                                                       @RequestParam() Integer size,
                                                       @RequestParam(required = false) String name) {
        return sweetArtistsService.getList(page, size, name);
    }

    @PostMapping("add")
    @ApiOperation("添加艺人")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "query", dataType = "String", name = "name", value = "艺人姓名", required = true),
            @ApiImplicitParam(type = "query", dataType = "String", name = "pinyin", value = "姓名拼音", required = true),
            @ApiImplicitParam(type = "query", dataType = "String", name = "describe", value = "艺人简介", required = true),
            @ApiImplicitParam(type = "query", dataType = "String[]", name = "picArray", value = "图片数组", required = true),
            @ApiImplicitParam(type = "query", dataType = "String[]", name = "videoArray", value = "视频数组", required = true)
    })
    public ResponseDto<Boolean> add(
                                    @RequestParam() String name,
                                    @RequestParam() String pinyin,
                                    @RequestParam() String describe,
                                    @RequestParam() String[] picArray,
                                    @RequestParam() String[] videoArray) {
        return sweetArtistsService.add( name, pinyin, describe,picArray,videoArray);
    }

    @GetMapping("detail")
    @ApiOperation("艺人详情")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "query", dataType = "String", name = "artistsId", value = "艺人Id", required = true),
    })
    public ResponseDto<SweetArtists> detail(@RequestParam() String artistsId) {
        return sweetArtistsService.detail(artistsId);
    }

    @PostMapping("change")
    @ApiOperation("修改艺人")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "query", dataType = "String", name = "artistsId", value = "艺人Id", required = true),
            @ApiImplicitParam(type = "query", dataType = "String", name = "picUrl", value = "图片", required = true),
            @ApiImplicitParam(type = "query", dataType = "String", name = "name", value = "艺人姓名", required = true),
            @ApiImplicitParam(type = "query", dataType = "String", name = "pinyin", value = "姓名拼音", required = true),
            @ApiImplicitParam(type = "query", dataType = "String", name = "describe", value = "艺人简介", required = true),
            @ApiImplicitParam(type = "query", dataType = "String[]", name = "picArray", value = "图片数组", required = true),
            @ApiImplicitParam(type = "query", dataType = "String[]", name = "videoArray", value = "视频数组", required = true)
    })
    public ResponseDto<Boolean> change(@RequestParam() String artistsId,
                                       @RequestParam() String picUrl,
                                       @RequestParam() String name,
                                       @RequestParam() String pinyin,
                                       @RequestParam() String describe,
                                       @RequestParam() String[] picArray,
                                       @RequestParam() String[] videoArray) {
        return sweetArtistsService.change(artistsId, picUrl, name, pinyin, describe,picArray,videoArray);
    }
    @GetMapping("del")
    @ApiOperation("删除艺人")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "query", dataType = "String", name = "artistsId", value = "艺人Id", required = true),
    })
    public ResponseDto<SweetArtists> del(@RequestParam() String artistsId) {
        return sweetArtistsService.del(artistsId);
    }
}
