/**
 * $Id$
 * Copyright(C) 2015-2020 kowlone - internet center, All Rights Reserved.
 */
package com.liquidnet.commons.lang.util;

import com.liquidnet.commons.lang.CommonConst;

import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;

/**
 * @author <a href="kowlone2006@163.com">kowlone</a>
 * @version 1.0 2015年09月28日 11:44:00
 */
public class AlgorithmUtils {

	public static byte[] hmacSha1(String key, String data) {
		try {
			SecretKeySpec sks = new SecretKeySpec(key.getBytes(CommonConst.DFT_CHARSET), "HmacSHA1");
			Mac mac = Mac.getInstance("HmacSHA1");
			mac.init(sks);
			return mac.doFinal(data.getBytes());
		} catch (NoSuchAlgorithmException | InvalidKeyException | UnsupportedEncodingException e) {
			throw new RuntimeException("hacSha1 error", e);
		}
	}


}
