package com.liquidnet.service.sweet.service.impl;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.liquidnet.commons.lang.util.IDGenerator;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.sweet.entity.SweetManualNotifyTfc;
import com.liquidnet.service.sweet.mapper.SweetManualNotifyTfcMapper;
import com.liquidnet.service.sweet.service.ISweetManualNotifyTFCService;
import com.liquidnet.service.sweet.utils.RedisTFCDataUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.time.LocalDateTime;
import java.util.List;

/**
 * <p>
 * 电子宣传手册通知表 服务实现类
 * </p>
 *
 * @author liquidnet
 * @since 2021-08-09
 */
@Service
public class SweetManualNotifyTFCServiceImpl extends ServiceImpl<SweetManualNotifyTfcMapper, SweetManualNotifyTfc> implements ISweetManualNotifyTFCService {

    @Autowired
    private SweetManualNotifyTfcMapper sweetManualNotifyTFCMapper;
    @Autowired
    private RedisTFCDataUtils redisDataUtils;

    @Override
    public ResponseDto<PageInfo<SweetManualNotifyTfc>> getList(Integer page, Integer size, String title, String manualId) {
        PageInfo<SweetManualNotifyTfc> pageInfo = null;
        try {
            PageHelper.startPage(page, size);
            List<SweetManualNotifyTfc> data;
            if (title != null) {
                data = sweetManualNotifyTFCMapper.selectList(Wrappers.lambdaQuery(SweetManualNotifyTfc.class).like(SweetManualNotifyTfc::getTitle, title).eq(SweetManualNotifyTfc::getManualId, manualId).eq(SweetManualNotifyTfc::getStatus, 1));
            } else {
                data = sweetManualNotifyTFCMapper.selectList(Wrappers.lambdaQuery(SweetManualNotifyTfc.class).eq(SweetManualNotifyTfc::getManualId, manualId).eq(SweetManualNotifyTfc::getStatus, 1));
            }
            pageInfo = new PageInfo(data);
            return ResponseDto.success(pageInfo);
        } catch (Exception e) {
            return ResponseDto.success(pageInfo);
        }
    }

    @Override
    public ResponseDto<Boolean> add(String manualId, String title, String content) {
        try {
            SweetManualNotifyTfc sweetManualNotify = SweetManualNotifyTfc.getNew();
            sweetManualNotify.setManualNotifyId(IDGenerator.nextSnowId());
            sweetManualNotify.setManualId(manualId);
            sweetManualNotify.setTitle(title);
            sweetManualNotify.setContent(content);
            sweetManualNotify.setCreatedAt(LocalDateTime.now());
            sweetManualNotifyTFCMapper.insert(sweetManualNotify);

            List<SweetManualNotifyTfc> oldData = redisDataUtils.getNotifyRedisData(manualId);
            oldData.add(sweetManualNotify);
            redisDataUtils.setNotifyRedisData(manualId, oldData);

            return ResponseDto.success();
        } catch (Exception e) {
            return ResponseDto.failure();
        }
    }

    @Override
    public ResponseDto<SweetManualNotifyTfc> details(String manualNotifyId) {
        try {
            return ResponseDto.success(sweetManualNotifyTFCMapper.selectOne(Wrappers.lambdaQuery(SweetManualNotifyTfc.class).eq(SweetManualNotifyTfc::getManualNotifyId, manualNotifyId).eq(SweetManualNotifyTfc::getStatus, 1)));
        } catch (Exception e) {
            return ResponseDto.failure();
        }
    }

    @Override
    public ResponseDto<Boolean> change(String manualId, String manualNotifyId, String title, String content) {
        try {
            SweetManualNotifyTfc sweetManualNotify = SweetManualNotifyTfc.getNew();
            sweetManualNotify.setTitle(title);
            sweetManualNotify.setContent(content);
            sweetManualNotify.setUpdatedAt(LocalDateTime.now());
            sweetManualNotifyTFCMapper.update(sweetManualNotify, Wrappers.lambdaUpdate(SweetManualNotifyTfc.class).eq(SweetManualNotifyTfc::getManualNotifyId, manualNotifyId));

            List<SweetManualNotifyTfc> oldData = redisDataUtils.getNotifyRedisData(manualId);
            for (SweetManualNotifyTfc item : oldData) {
                if (item.getManualNotifyId().equalsIgnoreCase(manualNotifyId)) {
                    item.setTitle(title);
                    item.setContent(content);
                    item.setUpdatedAt(LocalDateTime.now());
                }
            }
            redisDataUtils.setNotifyRedisData(manualId, oldData);

            return ResponseDto.success();
        } catch (Exception e) {
            return ResponseDto.failure();
        }
    }

    @Override
    public ResponseDto<Boolean> delete(String manualNotifyId) {
        try {
            SweetManualNotifyTfc sweetManualNotify = SweetManualNotifyTfc.getNew();
            sweetManualNotify.setStatus(0);
            sweetManualNotify.setUpdatedAt(LocalDateTime.now());
            sweetManualNotifyTFCMapper.update(sweetManualNotify, Wrappers.lambdaUpdate(SweetManualNotifyTfc.class).eq(SweetManualNotifyTfc::getManualNotifyId, manualNotifyId));
            return ResponseDto.success();
        } catch (Exception e) {
            return ResponseDto.failure();
        }
    }

}
