package com.liquidnet.service.consumer.adam.util;

import com.liquidnet.service.chime.constant.ChimeConstant;
import com.liquidnet.service.chime.vo.mongo.ChimeUserInfoVo;
import com.liquidnet.service.chime.vo.mongo.ChimeUserOperLogVo;
import com.mongodb.client.result.UpdateResult;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.stereotype.Component;

@Slf4j
@Component
public class ChimeDataUtils {

    @Autowired
    private MongoTemplate mongoTemplate;

    /**
     * 添加操作日志
     * @param chimeUserOperLogVo
     */
    public void createUserOperLog(ChimeUserOperLogVo chimeUserOperLogVo){
        mongoTemplate.save(chimeUserOperLogVo,ChimeUserOperLogVo.class.getSimpleName());
    }

    /**
     * 修改社交用户操作计数
     * @param chimeUserOperLogVo
     */
    public void updateChimeUser(ChimeUserOperLogVo chimeUserOperLogVo) {
        ChimeUserInfoVo chimeUserInfoVo = null;
        if(chimeUserOperLogVo.getOpType().equalsIgnoreCase(ChimeConstant.LOG_USER_OPERATION_LIKE)||chimeUserOperLogVo.getOpType().equalsIgnoreCase(ChimeConstant.LOG_USER_OPERATION_DISLIKE)){
            chimeUserInfoVo = this.getUserByUserId(chimeUserOperLogVo.getTargetUserId());
        }else if(chimeUserOperLogVo.getOpType().equalsIgnoreCase(ChimeConstant.LOG_USER_OPERATION_LIKE_MYSELF_CLICK)||chimeUserOperLogVo.getOpType().equalsIgnoreCase(ChimeConstant.LOG_USER_OPERATION_DISLIKE_MYSELF_CLICK)){
            chimeUserInfoVo = this.getUserByUserId(chimeUserOperLogVo.getCurrentUserId());
        }
        if(chimeUserInfoVo == null){
            log.error("chimeUserInfoVo is null userId is not exist:");
            return;
        }
        Query query = Query.query(Criteria.where("userId").is(chimeUserInfoVo.getUserId()));
        Update update = new Update();
        if(chimeUserOperLogVo.getOpType().equalsIgnoreCase(ChimeConstant.LOG_USER_OPERATION_LIKE)){
            update.set("likeCount", chimeUserInfoVo.getLikeCount() + 1);
        }else if(chimeUserOperLogVo.getOpType().equalsIgnoreCase(ChimeConstant.LOG_USER_OPERATION_DISLIKE)){
            update.set("disLikeCount", chimeUserInfoVo.getDisLikeCount() + 1);
        }else if(chimeUserOperLogVo.getOpType().equalsIgnoreCase(ChimeConstant.LOG_USER_OPERATION_LIKE_MYSELF_CLICK)){
            update.set("clickLikeCount", chimeUserInfoVo.getClickLikeCount() + 1);
        }else if(chimeUserOperLogVo.getOpType().equalsIgnoreCase(ChimeConstant.LOG_USER_OPERATION_DISLIKE_MYSELF_CLICK)){
            update.set("clickDisLikeCount", chimeUserInfoVo.getClickDisLikeCount() + 1);
        }

        UpdateResult result = mongoTemplate.updateFirst(query,update,ChimeUserInfoVo.class,ChimeUserInfoVo.class.getSimpleName());
        log.info("updateChimeUser result:{}",result.toString());

//        Query query = Query.query(Criteria.where("userId").is(chimeUserInfoVo.getUserId()));
////        Update update = Update.fromDocument(Document.parse(JsonUtils.toJson(chimeUserInfoVo)));
//        Update update = Update.fromDocument(Document.parse(JsonUtils.toJson(chimeUserInfoVo)));
//        if(chimeUserOperLogVo.getOpType().equalsIgnoreCase(ChimeConstant.LOG_USER_OPERATION_LIKE)){
//            update.set("likeCount", chimeUserInfoVo.getLikeCount() + 1);
//        }else if(chimeUserOperLogVo.getOpType().equalsIgnoreCase(ChimeConstant.LOG_USER_OPERATION_DISLIKE)){
//            update.set("disLikeCount", chimeUserInfoVo.getDisLikeCount() + 1);
//        }
//        update.set("likeCount", 8);
//        update.set("disLikeCount", 9);
//        UpdateResult result = mongoTemplate.updateFirst(query,update,ChimeUserInfoVo.class,ChimeUserInfoVo.class.getSimpleName());
//        log.info("updateChimeUser result:{}",result.toString());
    }

    /**
     * 获取单个用户信息
     * @param userId
     * @return
     */
    public ChimeUserInfoVo getUserByUserId(String userId){
        Query query = Query.query(Criteria.where("userId").is(userId));
        ChimeUserInfoVo chimeUserInfoVo = mongoTemplate.findOne(query,ChimeUserInfoVo.class,ChimeUserInfoVo.class.getSimpleName());
        return chimeUserInfoVo;
    }
}
