package com.liquidnet.service.platform.controller.kylin;


import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.platform.service.impl.kylin.DMCheckOrderTimeImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * <p>
 * 订单 前端控制器
 * </p>
 *
 * @author liquidnet
 * @since 2021-05-20
 */
@Api(tags = "前端-订单相关")
@RestController
@RequestMapping("order")
@Validated
public class KylinOrderTicketsController {

    @Autowired
    DMCheckOrderTimeImpl kylinCheckOrderTime;

    @PostMapping("checkOrderTime")
    @ApiOperation("订单过期脚本")
    @ApiResponse(code = 200, message = "接口返回对象参数")
    public ResponseDto<Boolean> checkOrderTime() {
        return ResponseDto.success(kylinCheckOrderTime.checkOrderTime(""));
    }

    @PostMapping("checkTransferOrder")
    @ApiOperation("转赠订单失效脚本")
    @ApiResponse(code = 200, message = "接口返回对象参数")
    public ResponseDto<Boolean> checkTransferOrder(@RequestParam Integer minute) {
        return ResponseDto.success(kylinCheckOrderTime.checkTransferOrder(minute));
    }
}
