package com.liquidnet.service.kylin.controller;


import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.kylin.dto.vo.PerformanceVo;
import com.liquidnet.service.kylin.service.impl.KylinPerformancesServiceImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.HashMap;
import java.util.List;

/**
 * <p>
 * 演出 前端控制器
 * </p>
 *
 * @author jiangxiulong
 * @since 2021-05-11
 */
@Api(tags = "前端-演出")
@RestController
@RequestMapping("performance")
public class KylinPerformancesController {

    @Autowired
    private KylinPerformancesServiceImpl kylinPerformancesService;

    @GetMapping("localList")
    @ApiOperation("本地演出列表")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "query", dataType = "String", name = "sellTime", value = "开票时间 2021-01-01"),
            @ApiImplicitParam(type = "query", dataType = "Integer", name = "days", value = "时间范围 几天 今天1 三天3。。。"),
            @ApiImplicitParam(type = "query", dataType = "String", name = "title", value = "演出名称"),
            @ApiImplicitParam(type = "query", dataType = "String", name = "cityName", value = "城市名称"),
            @ApiImplicitParam(type = "query", dataType = "Integer", name = "type", value = "演出类型 1音乐节 2演唱会 3小型演出 4展览 6舞台剧"),

            @ApiImplicitParam(type = "query", dataType = "Integer", name = "isDiscount", value = "是否会员优惠 0 1"),
            @ApiImplicitParam(type = "query", dataType = "Integer", name = "isAdvance", value = "是否优先 0 1"),
            @ApiImplicitParam(type = "query", dataType = "Integer", name = "isExclusive", value = "是否会员专属 0 1"),

            @ApiImplicitParam(type = "query", dataType = "Integer", name = "page", value = "页码"),
            @ApiImplicitParam(type = "query", dataType = "Integer", name = "size", value = "每页数量"),

            @ApiImplicitParam(type = "query", dataType = "String", name = "orderBy", value = "排序字段 时间sellTime"),
            @ApiImplicitParam(type = "query", dataType = "String", name = "sort", value = "排序方式[DESC ASC]"),
    })
    public ResponseDto<HashMap<String, Object>> localList(
            @RequestParam(defaultValue = "") String sellTime,
            @RequestParam(defaultValue = "") Integer days,
            @RequestParam(defaultValue = "") String title,
            @RequestParam(defaultValue = "") String cityName,
            @RequestParam(defaultValue = "") Integer type,

            @RequestParam(defaultValue = "") Integer isDiscount,
            @RequestParam(defaultValue = "") Integer isAdvance,
            @RequestParam(defaultValue = "") Integer isExclusive,


            @RequestParam(defaultValue = "1") Integer page,
            @RequestParam(defaultValue = "10") Integer size,

            // 排序
            @RequestParam(defaultValue = "") String orderBy,
            @RequestParam(defaultValue = "") String sort
    ) {
        HashMap<String, Object> result = kylinPerformancesService.localList(
                sellTime, days, title, cityName, type,
                isDiscount, isAdvance, isExclusive,
                page, size,
                orderBy, sort
        );

        return ResponseDto.success(result);
    }

    @GetMapping("noticeList")
    @ApiOperation("演出预告列表")
    public ResponseDto<HashMap<String, Object>> noticeList() {
        HashMap<String, Object> result = kylinPerformancesService.noticeList();
        return ResponseDto.success(result);
    }

    @GetMapping("recommendList")
    @ApiOperation("推荐演出列表")
    public ResponseDto<List<PerformanceVo>> recommendList() {
        List<PerformanceVo> result = kylinPerformancesService.recommendList();
        return ResponseDto.success(result);
    }

    @GetMapping("{performancesId}")
    @ApiOperation("演出详情")
    public ResponseDto<HashMap<String, Object>> detail(@PathVariable("performancesId") String performancesId) {
        HashMap<String, Object> result = kylinPerformancesService.detail(performancesId);
        if (result.size() > 0) {
            return ResponseDto.success(result);
        } else {
            return ResponseDto.failure("获取演出列表失败");
        }
    }

}
