package com.liquidnet.common.third.xuper.dto;

import lombok.Data;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: 拉取数字商品历史登记记录
 * @class: Xuper001GetStokenReqDto
 * @Package com.liquidnet.common.third.xuper.dto
 * @Copyright: LightNet @ Copyright (c) 2022
 * @date 2022/4/18 15:10
 */
@Data
public class Xuper013HistoryReqDto {
    //资产id
    private long assetId;
    //要拉取页数，第一页为1
    private int page = 1;
    //每页拉取数量，默认20，最大50（可选）
    private int limit = 20;

    private static final Xuper013HistoryReqDto obj = new Xuper013HistoryReqDto();
    public static Xuper013HistoryReqDto getNew() {
        try {
            return (Xuper013HistoryReqDto) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new Xuper013HistoryReqDto();
        }
    }
}
