package com.liquidnet.client.admin.web.controller.zhengzai.kylin;

import com.github.pagehelper.PageInfo;
import com.liquidnet.client.admin.common.core.controller.BaseController;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.kylin.dao.PerformanceAdminListDao;
import com.liquidnet.service.kylin.dto.param.PerformanceAdminListParam;
import com.liquidnet.service.kylin.service.admin.IKylinPerformancesAdminService;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;


/**
 * 演出Controller
 * 
 * @author anjiabin
 * @date 2021-05-24
 */
@Controller
@RequestMapping("/kylin/performances")
public class KylinPerformancesController extends BaseController
{
    private String prefix = "zhengzai/kylin/performances";

    @Autowired
    private IKylinPerformancesAdminService kylinPerformancesService;

    @RequiresPermissions("kylin:performances:view")
    @GetMapping()
    public String performances()
    {
        return prefix + "/performances";
    }

    /**
     * 查询演出列表
     */
    @RequiresPermissions("kylin:performances:list")
    @PostMapping("/list")
    @ResponseBody
    public ResponseDto<PageInfo<PerformanceAdminListDao>> list(PerformanceAdminListParam performanceAdminListParam)
    {
        PageInfo<PerformanceAdminListDao> result = null;
        result = kylinPerformancesService.getList(performanceAdminListParam);
        if (null != result) {
            return ResponseDto.success(result);
        } else {
            return ResponseDto.failure("获取演出详情失败");
        }
    }
//
//    /**
//     * 导出演出列表
//     */
//    @RequiresPermissions("kylin:performances:export")
//    @Log(title = "演出", businessType = BusinessType.EXPORT)
//    @PostMapping("/export")
//    @ResponseBody
//    public AjaxResult export(KylinPerformances kylinPerformances)
//    {
//        List<KylinPerformances> list = kylinPerformancesService.selectKylinPerformancesList(kylinPerformances);
//        ExcelUtil<KylinPerformances> util = new ExcelUtil<KylinPerformances>(KylinPerformances.class);
//        return util.exportExcel(list, "演出数据");
//    }
//
//    /**
//     * 新增演出
//     */
//    @GetMapping("/add")
//    public String add()
//    {
//        return prefix + "/add";
//    }
//
//    /**
//     * 新增保存演出
//     */
//    @RequiresPermissions("kylin:performances:add")
//    @Log(title = "演出", businessType = BusinessType.INSERT)
//    @PostMapping("/add")
//    @ResponseBody
//    public AjaxResult addSave(KylinPerformances kylinPerformances)
//    {
//        return toAjax(kylinPerformancesService.insertKylinPerformances(kylinPerformances));
//    }
//
//    /**
//     * 修改演出
//     */
//    @GetMapping("/edit/{mid}")
//    public String edit(@PathVariable("mid") Long mid, ModelMap mmap)
//    {
//        KylinPerformances kylinPerformances = kylinPerformancesService.selectKylinPerformancesById(mid);
//        mmap.put("kylinPerformances", kylinPerformances);
//        return prefix + "/edit";
//    }
//
//    /**
//     * 修改保存演出
//     */
//    @RequiresPermissions("kylin:performances:edit")
//    @Log(title = "演出", businessType = BusinessType.UPDATE)
//    @PostMapping("/edit")
//    @ResponseBody
//    public AjaxResult editSave(KylinPerformances kylinPerformances)
//    {
//        return toAjax(kylinPerformancesService.updateKylinPerformances(kylinPerformances));
//    }
//
//    /**
//     * 删除演出
//     */
//    @RequiresPermissions("kylin:performances:remove")
//    @Log(title = "演出", businessType = BusinessType.DELETE)
//    @PostMapping( "/remove")
//    @ResponseBody
//    public AjaxResult remove(String ids)
//    {
//        return toAjax(kylinPerformancesService.deleteKylinPerformancesByIds(ids));
//    }
}
