package com.liquidnet.service.platform.service.impl.goblin;

import com.liquidnet.service.goblin.dto.vo.GoblinGoodsInfoVo;
import com.liquidnet.service.platform.utils.GoblinRedisUtils;
import com.liquidnet.service.platform.utils.QueueUtils;
import com.mongodb.BasicDBObject;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.convert.MongoConverter;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;

import java.util.List;


/**
 * <p>
 * 订单 服务实现类
 * </p>
 *
 * @author liquidnet
 * @since 2021-05-20
 */
@Service
@Slf4j
public class SpuGoodsInfoImpl {

    @Autowired
    private GoblinRedisUtils goblinRedisUtils;
    @Autowired
    private MongoTemplate mongoTemplate;
    @Autowired
    private MongoConverter mongoConverter;
    @Autowired
    private QueueUtils queueUtils;

    /**
     * 设置商品数量
     */
    public boolean setCount(){
        //mongoTemplate.findOne(Query.query(Criteria.where("spuId").is(spuId).and("delFlg").is("0").and("shelvesStatus").is("3")),
        //                GoblinGoodsInfoVo.class, GoblinGoodsInfoVo.class.getSimpleName());  shelvesStatus
        List<GoblinGoodsInfoVo> voList = mongoTemplate.find(Query.query(Criteria.where("delFlg").is("0").and("shelvesStatus").is("3")),
                GoblinGoodsInfoVo.class, GoblinGoodsInfoVo.class.getSimpleName());
        for(GoblinGoodsInfoVo goblinGoodsInfoVo:voList){
                //查询数量
            Integer counts=goblinRedisUtils.getSpuSaleCount(goblinGoodsInfoVo.getSpuId());
            if(counts==null){
                goblinGoodsInfoVo.setCount(0);
            }else{
                goblinGoodsInfoVo.setCount(counts);
            }
            //修改mongodb
            BasicDBObject obj = new BasicDBObject("$set", mongoConverter.convertToMongoType(goblinGoodsInfoVo));
            mongoTemplate.getCollection(GoblinGoodsInfoVo.class.getSimpleName()).updateOne(
                    Query.query(Criteria.where("spuId").is(goblinGoodsInfoVo.getSpuId())).getQueryObject(),
                    obj);
        }
        log.info("执行完毕");
        return true;
    }
}
