package com.liquidnet.client.admin.web.controller.zhengzai.kylin;


import com.liquidnet.client.admin.common.core.controller.BaseController;
import com.liquidnet.client.admin.common.core.domain.AjaxResult;
import com.liquidnet.client.admin.common.core.page.TableDataInfo;
import com.liquidnet.client.admin.zhengzai.kylin.service.impl.KylinRecommendActiveRelationServiceImpl;
import com.liquidnet.client.admin.zhengzai.kylin.service.impl.KylinRecommendActiveServiceImpl;
import com.liquidnet.service.kylin.dto.param.KylinRecommendActiveParam;
import com.liquidnet.service.kylin.dto.param.KylinRecommendActiveRelationParam;
import com.liquidnet.service.kylin.entity.KylinRecommendActive;
import com.liquidnet.service.kylin.entity.KylinRecommendActiveRelation;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.List;

/**
 * <p>
 * 推荐活动表 前端控制器
 * </p>
 */
@Api(tags = "推荐活动controller")
@RestController
@RequestMapping("/kylin-recommend-active")
public class KylinRecommendActiveController extends BaseController {
    @Autowired
    private KylinRecommendActiveServiceImpl kylinRecommendActiveService;
    @Autowired
    private KylinRecommendActiveRelationServiceImpl kylinRecommendActiveRelationService;

    @PostMapping("addKylinRecommendActive")
    @ApiOperation(value = "增加活动")
    @ResponseBody
    public AjaxResult addKylinRecommendActive(@RequestBody KylinRecommendActiveParam kylinRecommendActiveParam) {
        KylinRecommendActive kylinRecommendActive = new KylinRecommendActive();
        BeanUtils.copyProperties(kylinRecommendActiveParam, kylinRecommendActive);
        if (kylinRecommendActiveService.validateTime(kylinRecommendActive) == 0) {
            List<KylinRecommendActiveRelation> list = new ArrayList<KylinRecommendActiveRelation>();
            if (kylinRecommendActiveParam.getList() != null) {
                kylinRecommendActiveParam.getList().forEach(r -> {
                    KylinRecommendActiveRelation kylinRecommendActiveRelation = new KylinRecommendActiveRelation();
                    BeanUtils.copyProperties(r, kylinRecommendActiveRelation);
                    list.add(kylinRecommendActiveRelation);
                });
            }
            kylinRecommendActiveService.addKylinRecommendActive(kylinRecommendActive, list);
            return AjaxResult.success("操作成功", "");
        } else {
            return AjaxResult.error("该时间段已经重复，请重新选择");
        }
    }

    @PostMapping("addKylinRecommendActiveRelation")
    @ApiOperation(value = "增加活动推荐")
    @ResponseBody
    public AjaxResult addKylinRecommendActiveRelation(@RequestBody KylinRecommendActiveRelationParam kylinRecommendActiveParam) {
        KylinRecommendActiveRelation kylinRecommendActiveRelation = new KylinRecommendActiveRelation();
        BeanUtils.copyProperties(kylinRecommendActiveParam, kylinRecommendActiveRelation);
        kylinRecommendActiveRelationService.addKylinRecommendActiveRelation(kylinRecommendActiveRelation);
        return AjaxResult.success("操作成功", "");
    }
    @PostMapping("addOrUpdateListKylinRecommendActiveRelation")
    @ApiOperation(value = "增加或者修改活动推荐List")
    @ResponseBody
    public AjaxResult addOrUpdateListKylinRecommendActiveRelation(@RequestBody List<KylinRecommendActiveRelationParam> kylinRecommendActiveParam) {
        List<KylinRecommendActiveRelation> list=new ArrayList<>();
        for(KylinRecommendActiveRelationParam ky:kylinRecommendActiveParam){
            KylinRecommendActiveRelation kylinRecommendActiveRelation = new KylinRecommendActiveRelation();
            BeanUtils.copyProperties(ky, kylinRecommendActiveRelation);
            list.add(kylinRecommendActiveRelation);
        }
        kylinRecommendActiveRelationService.addListKylinRecommendActiveRelation(list);
        return AjaxResult.success("操作成功", "");
    }

    @PostMapping("delKylinRecommendActiveRelation")
    @ApiOperation(value = "删除活动推荐(传入互动推荐里面的mid)")
    @ResponseBody
    public AjaxResult delKylinRecommendActiveRelation(@RequestBody KylinRecommendActiveRelation kylinRecommendActiveRelation) {
        kylinRecommendActiveRelationService.deleteKylinRecommendActiveRelation(kylinRecommendActiveRelation);
        return AjaxResult.success("操作成功", "");
    }


    @PostMapping("updateKylinRecommendActive")
    @ApiOperation(value = "修改活动")
    @ResponseBody
    public AjaxResult updateKylinRecommendActive(@RequestBody KylinRecommendActiveParam kylinRecommendActiveParam) {
        KylinRecommendActive kylinRecommendActive = new KylinRecommendActive();
        BeanUtils.copyProperties(kylinRecommendActiveParam, kylinRecommendActive);
        if (kylinRecommendActiveService.validateTime(kylinRecommendActive) == 0) {
            kylinRecommendActiveService.updateKylinRecommendActive(kylinRecommendActive);
            return AjaxResult.success("操作成功", "");
        } else {
            return AjaxResult.error("该时间段已经重复，请重新选择");
        }

    }


    @PostMapping("pageActive")
    @ApiOperation(value = "分页活动")
    @ResponseBody
    public TableDataInfo pageActive(@RequestParam(name = "pageSize", required = true) int pageSize, @RequestParam(name = "pageNum", required = true) int pageNum) {
        //return AjaxResult.success(kylinAcitveService.pageKylinAcitve(pageSize,pageNum));
        return getDataTable(kylinRecommendActiveService.pageKylinAcitve(pageSize, pageNum));
    }

    @PostMapping("getActiveById")
    @ApiOperation(value = "通过id获得活动")
    @ResponseBody
    public KylinRecommendActive getActiveById(@RequestParam(name = "mid", required = true) int mid) {
        return kylinRecommendActiveService.getKylinRecommendActiveById(mid);
    }
}
