package com.liquidnet.service.sweet.service.impl.syncRedis;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.liquidnet.common.cache.redis.util.RedisUtil;
import com.liquidnet.service.adam.dto.vo.admin.AdminUpushVo;
import com.liquidnet.service.kylin.constant.KylinRedisConst;
import com.liquidnet.service.kylin.dto.vo.admin.ZhengzaiAppVersionsVo;
import com.liquidnet.service.kylin.entity.KylinBanners;
import com.liquidnet.service.sweet.entity.SweetWechatUser;
import com.liquidnet.service.sweet.vo.SweetAnswerVo;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Set;

@Service
@Slf4j
public class JxlDataImpl {

    @Autowired
    private RedisUtil redisUtil;

    private static final JedisPool jedisPool;
    private static final ObjectMapper toObjMapper;

    static {
        //        r-2ze7002ckw5u75fgukpd.redis.rds.aliyuncs.com test
//        39.106.122.201 dev
//        zhengzai.redis.rds.aliyuncs.com 线上
        jedisPool = new JedisPool("zhengzai.redis.rds.aliyuncs.com", 6380);

        toObjMapper = new ObjectMapper();
        toObjMapper.setVisibility(PropertyAccessor.ALL, JsonAutoDetect.Visibility.ANY);
        toObjMapper.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
        toObjMapper.registerModule(new JavaTimeModule());
        toObjMapper.activateDefaultTyping(toObjMapper.getPolymorphicTypeValidator(), ObjectMapper.DefaultTyping.NON_FINAL);
    }

    private Jedis getRedis() {
        Jedis resource = jedisPool.getResource();
        resource.auth("NBs$%6hW"); // 线上
//        resource.auth("PO@B!Iud32"); // test
        resource.select(15);
        return resource;
    }

    public Boolean basicServicesVersions() {
        try {
//        RedisTemplate<String, Object> redis = redisUtil.getRedisTemplateByDb(15);
            Jedis redis = getRedis();

            String appAndroid = KylinRedisConst.ZHENGZAI_APP_VERSIONS_ANDROID;
            String appIos = KylinRedisConst.ZHENGZAI_APP_VERSIONS_IOS;
            String checkAndroid = KylinRedisConst.ZHENGZAI_APP_VERSIONS_CHECK_ANDROID;
            String checkIos = KylinRedisConst.ZHENGZAI_APP_VERSIONS_CHECK_IOS;

            ZhengzaiAppVersionsVo appAndroidValue = toObjMapper.readValue(redis.get(appAndroid), ZhengzaiAppVersionsVo.class);
            redisUtil.set(appAndroid, appAndroidValue);
            ZhengzaiAppVersionsVo appIosValue = toObjMapper.readValue(redis.get(appIos), ZhengzaiAppVersionsVo.class);
            redisUtil.set(appIos, appIosValue);
            ZhengzaiAppVersionsVo checkAndroidValue = toObjMapper.readValue(redis.get(checkAndroid), ZhengzaiAppVersionsVo.class);
            redisUtil.set(checkAndroid, checkAndroidValue);
            ZhengzaiAppVersionsVo checkIosValue = toObjMapper.readValue(redis.get(checkIos), ZhengzaiAppVersionsVo.class);
            redisUtil.set(checkIos, checkIosValue);

            return true;
        } catch (Exception e) {
            log.error("basicServicesVersionsError", e);
            return false;
        }
    }

    public Boolean basicServicesUpush() {
        try {
//        RedisTemplate<String, Object> redis = redisUtil.getRedisTemplateByDb(15);
            Jedis redis = getRedis();

            String pushAndroid = KylinRedisConst.ADMIN_UPUSH_LIST_IOS;
            String pushIos = KylinRedisConst.ADMIN_UPUSH_LIST_ANDROID;

//            LinkedList<AdminUpushVo> pushAndroidList = (LinkedList<AdminUpushVo>) redis.get(pushAndroid);
            LinkedList<AdminUpushVo> pushAndroidList = toObjMapper.readValue(redis.get(pushAndroid), new TypeReference<LinkedList<AdminUpushVo>>() {
            });
            redisUtil.set(pushAndroid, pushAndroidList);
//            LinkedList<AdminUpushVo> pushIosList = (LinkedList<AdminUpushVo>) redis.get(pushIos);
            LinkedList<AdminUpushVo> pushIosList = toObjMapper.readValue(redis.get(pushIos), new TypeReference<LinkedList<AdminUpushVo>>() {
            });
            redisUtil.set(pushIos, pushIosList);

            return true;
        } catch (Exception e) {
            log.error("basicServicesUpushError", e);
            return false;
        }
    }

    public Boolean sweetAccessToken() {
//        sweet:accessToken:applet:zhengzai:access_token:wx4732efeaa2b08086
//        sweet:accessToken:applet:strawberry:access_token:wx08b852ade69f8019
        return true;
    }

    public Boolean sweetAnswer() {
        try {
//        RedisTemplate<String, Object> redis = redisUtil.getRedisTemplateByDb(15);
            Jedis redis = getRedis();

            String redisKey = "sweet:answer:phone*";

            Set<String> keys = redis.keys(redisKey);
            for (String key : keys) {
                SweetAnswerVo answer = toObjMapper.readValue(redis.get(key), SweetAnswerVo.class);
                redisUtil.set(key, answer);
            }

            return true;
        } catch (Exception e) {
            log.error("sweetAnswerError", e);
            return false;
        }
    }

    public Boolean sweetOpenId() {
        try {
//        RedisTemplate<String, Object> redis = redisUtil.getRedisTemplateByDb(15);
            Jedis redis = getRedis();

            String redisKey = "sweet:wechatUser:openId*";

            Set<String> keys = redis.keys(redisKey);
            for (String key : keys) {
                String value = redis.get(key);
                redisUtil.set(key, value);
            }

            return true;
        } catch (Exception e) {
            log.error("sweetOpenIdError", e);
            return false;
        }
    }

    public Boolean sweetUnionId() {
        try {
//        RedisTemplate<String, Object> redis = redisUtil.getRedisTemplateByDb(15);
            Jedis redis = getRedis();

            String redisKey = "sweet:wechatUser:unionId*";

            Set<String> keys = redis.keys(redisKey);
            for (String key : keys) {
                try {
                    SweetWechatUser userInfo = toObjMapper.readValue(redis.get(key), SweetWechatUser.class);
                    redisUtil.set(key, userInfo);
                } catch (Exception e) {
                    log.error("同步wechatUser失败" + key, e);
                }
            }

            return true;
        } catch (Exception e) {
            log.error("sweetUnionIdError", e);
            return false;
        }
    }

    public Boolean sweetUnionIdStr() {
        try {
//        RedisTemplate<String, Object> redis = redisUtil.getRedisTemplateByDb(15);
            Jedis redis = getRedis();

            String redisKey = "sweet:wechatUser:unionIdStr*";

            Set<String> keys = redis.keys(redisKey);
            for (String key : keys) {
                String value = redis.get(key);
                redisUtil.set(key, value);
            }

            return true;
        } catch (Exception e) {
            log.error("sweetUnionIdStrError", e);
            return false;
        }
    }

    public Boolean kylinBanner() {
        try {
//        RedisTemplate<String, Object> redis = redisUtil.getRedisTemplateByDb(15);
            Jedis redis = getRedis();

            String bannerKey = KylinRedisConst.ADMIN_BANNER_LIST;

//            ArrayList<KylinBanners> bannerList = (ArrayList<KylinBanners>) redis.get(bannerKey);
            ArrayList<KylinBanners> bannerList = toObjMapper.readValue(redis.get(bannerKey), new TypeReference<ArrayList<KylinBanners>>() {
            });
            redisUtil.set(bannerKey, bannerList);

            return true;
        } catch (Exception e) {
            log.error("kylinBannerError", e);
            return false;
        }
    }
}
