package com.liquidnet.service.goblin.dto.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.liquidnet.commons.lang.util.DateUtil;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * @author TT
 */
@Data
public class GoblinGoodsAnticipateHelp implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * skuId
     */
    private String skuId;

    /**
     * 预约类型
     */
    private Integer type;

    /**
     * 配置预约人数
     */
    private Integer people;

    /**
     * 预约开始时间
     */
    @ApiModelProperty(value = "预约开始时间")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = DateUtil.DATE_FULL_STR)
    private LocalDateTime aboutStartDate;

    /**
     * 预约结束时间
     */
    @ApiModelProperty(value = "预约结束时间")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = DateUtil.DATE_FULL_STR)
    private LocalDateTime aboutEndDate;

    /**
     * 创建时间
     */
    private LocalDateTime createDate;

    private static final GoblinGoodsAnticipateHelp obj = new GoblinGoodsAnticipateHelp();

    public static GoblinGoodsAnticipateHelp getNew() {
        try {
            return (GoblinGoodsAnticipateHelp) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new GoblinGoodsAnticipateHelp();
        }
    }

}
