package com.liquidnet.service.dragon.entity;

import java.math.BigDecimal;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import java.io.Serializable;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * <p>
 * 退款订单表
 * </p>
 *
 * @author liquidnet
 * @since 2021-07-20
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class DragonOrderRefunds implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "mid", type = IdType.AUTO)
    private Long mid;

    /**
     * order_refund_id
     */
    private String orderRefundId;

    /**
     * 订单id
     */
    private Long orderId;

    /**
     * 订单退款状态
     */
    private Integer status;

    /**
     * 订单退款编号
     */
    private String code;

    /**
     * 调用端订单退款编号
     */
    private String orderRefundCode;

    /**
     * 退款价格
     */
    private BigDecimal price;

    /**
     * 退款原因
     */
    private String reason;

    /**
     * 退款完成通知回调地址
     */
    private String notifyUrl;

    /**
     * 退款类型
     */
    private String refundType;

    /**
     * 退款的订单号
     */
    private String refundId;

    /**
     * 退款失败原因
     */
    private String refundError;

    /**
     * 退款时间
     */
    private LocalDateTime refundAt;

    /**
     * 退款结束时间
     */
    private LocalDateTime finishedAt;

    /**
     * 创建时间
     */
    private LocalDateTime createdAt;

    /**
     * 更新时间
     */
    private LocalDateTime updatedAt;

    /**
     * 删除时间
     */
    private LocalDateTime deletedAt;


}
