package com.liquidnet.service.adam.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * <p>
 * 用户
 * </p>
 *
 * @author liquidnet
 * @since 2021-05-11
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class AdamUser implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "mid", type = IdType.AUTO)
    private Long mid;

    private String uid;

    private String mobile;

    private String passwd;

    private String payCode;

    /**
     * 1-NORMAL,2-INVALID
     */
    private Integer state;

    /**
     * 完善信息进度:0-未完善,1-已完善
     */
    private Integer isComplete;

    private LocalDateTime createdAt;

    private LocalDateTime updatedAt;

    private LocalDateTime closedAt;

    private String comment;
}
