package com.liquidnet.service.goblin.controller;

import com.liquidnet.common.cache.redis.util.RedisUtil;
import com.liquidnet.commons.lang.util.DateUtil;
import com.liquidnet.commons.lang.util.StringUtil;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.goblin.constant.GoblinRedisConst;
import com.liquidnet.service.goblin.constant.GoblinStatusConst;
import com.liquidnet.service.goblin.dto.vo.*;
import com.liquidnet.service.goblin.entity.GoblinFrontBanner;
import com.liquidnet.service.goblin.entity.GoblinFrontHotWord;
import com.liquidnet.service.goblin.entity.GoblinFrontNavigation;
import com.liquidnet.service.goblin.entity.GoblinFrontSeckill;
import com.liquidnet.service.goblin.util.GoblinRedisUtils;
import com.liquidnet.service.goblin.util.ObjectUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

/**
 * @author zhangfuxin
 * @Description:前端接口
 * @date 2021/12/27 下午6:25
 */
@Api(tags = "前端接口管理")
@RestController
@RequestMapping("/front")
public class GoblinFrontController {
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    private GoblinRedisUtils goblinRedisUtils;

    @GetMapping("getBanner")
    @ApiOperation("获取banner")
    public ResponseDto getBanner() {
        List<GoblinFrontBanner> list= (List<GoblinFrontBanner>) redisUtil.get(GoblinRedisConst.FRONT_BANNER);
        LocalDateTime nowTime= LocalDateTime.now();
        ArrayList<GoblinFrontBanner> goblinFrontBannerArrayList=ObjectUtil.getGoblinFrontBannerArrayList();
        //查看是否有失效的时间
        for(GoblinFrontBanner goblinFrontBanner:list){
            if(null!=goblinFrontBanner.getEndTime()){
                if( nowTime.isAfter(goblinFrontBanner.getEndTime())){
                }else{
                    goblinFrontBannerArrayList.add(goblinFrontBanner);
                }
            }
        }
        ArrayList<GoblinFrontBannerVo> list1= ObjectUtil.goblinFrontBannerVoArrayList();
        for(GoblinFrontBanner goblinFrontBanner:goblinFrontBannerArrayList){
            GoblinFrontBannerVo goblinFrontBannerVo=GoblinFrontBannerVo.getNew();
            BeanUtils.copyProperties(goblinFrontBanner,goblinFrontBannerVo);
            list1.add(goblinFrontBannerVo);
        }

        //redis里获取banner
        return ResponseDto.success( list1);
    }
    @GetMapping("getHotWord")
    @ApiOperation("获得热词")
    public ResponseDto getHotWord() {
        int index= (int) redisUtil.get(GoblinRedisConst.FRONT_HOTWORD_INDEX);
        //获得value
        List<GoblinFrontHotWord> list= (List<GoblinFrontHotWord>) redisUtil.get(GoblinRedisConst.FRONT_HOTWORD);
        index++;
        String hotWord="";
        redisUtil.set(GoblinRedisConst.FRONT_HOTWORD_INDEX,index);
        if(index<list.size()){
            hotWord= list.get(index).getWord();
        }else{
            hotWord= list.get(0).getWord();
        }
        return ResponseDto.success( hotWord );
    }
    @GetMapping("getNavigation")
    @ApiOperation("获得金刚栏")
    public ResponseDto getNavigation() {
        List<GoblinFrontNavigation> list = (List<GoblinFrontNavigation>) redisUtil.get(GoblinRedisConst.FRONT_NAVIGATION);
        return ResponseDto.success( list );
    }

    @GetMapping("getSeckilll")
    @ApiOperation("获得秒杀首页要用的")
    public ResponseDto getSeckilll() throws ParseException {
        //获得秒杀列表绑定
        List<GoblinFrontSeckill> list= (List<GoblinFrontSeckill>) redisUtil.get(GoblinRedisConst.FRONT_SECKILL);
        GoblinFrontSeckillVo goblinFrontSeckillVo=GoblinFrontSeckillVo.getNew();
        ArrayList<GoblinGoodsInfoVo> goblinGoodsInfoVoArrayList=ObjectUtil.goblinGoodsInfoVoArrayList();
        //判断是否有
        if(null!=list&&list.size()>0){
            //遍历秒杀， 找到对应的  官方、商铺
            GoblinFrontSeckill goblinFrontSeckill=list.get(0);
            boolean openBoolean=goblinFrontSeckill.getActivityType()==2;
            String ids=goblinFrontSeckill.getSelfActivityids();
            if(StringUtil.isNotBlank(ids)){
                String[] idss=ids.split(",");
                for(String id:idss){
                    String type=id.split("_")[0];
                    String idM=id.split("_")[1];
                    if(type.equals("g")){
                        //找到对应官方的活动 判断时间是否过期，
                        GoblinSelfMarketingVo goblinSelfMarketingVo=goblinRedisUtils.getSelfMarket(idM);
                        if(!StringUtil.isNotBlank(goblinFrontSeckillVo.getStartTime())){
                            goblinFrontSeckillVo.setStartTime(goblinSelfMarketingVo.getStartTime());
                            goblinFrontSeckillVo.setEndTime(goblinSelfMarketingVo.getEndTime());
                        }
                        if(goblinSelfMarketingVo==null){
                            break;
                        }
                        if(!openBoolean){
                            //效验该活动是否在当前时间
                            if(!belongCalendar(goblinSelfMarketingVo.getStartTime(),goblinSelfMarketingVo.getEndTime())){
                                //如果不是在当前时间
                                break;
                            }
                        }
                        //查看 活动绑定的 spu   sku
                        List<GoblinMarketRelationVo>  list1=goblinRedisUtils.getMarketRelation(GoblinStatusConst.MarketPreStatus.MARKET_PRE_PURCHASE.getValue(),goblinSelfMarketingVo.getSelfMarketId());
                        //遍历 活动表
                        for(GoblinMarketRelationVo goblinMarketRelationVo:list1){
                            //找到对应的spu商品
                            GoblinGoodsInfoVo goblinGoodsInfoVo=goblinRedisUtils.getGoodsInfoVo(goblinMarketRelationVo.getSpuId());
                            //遍历sku 找到
                            List<String> skuList=goblinMarketRelationVo.getSkuList();
                            int sellPrice=0;
                            int i=0;
                            for(String skuId:skuList){
                                GoblinGoodsSkuInfoVo goblinGoodsSkuInfoVo= goblinRedisUtils.getGoodsSkuInfoVo(skuId);
                                if(null!=goblinGoodsSkuInfoVo){
                                    if(i==0){
                                        sellPrice=goblinGoodsSkuInfoVo.getSellPrice().intValue();
                                    }
                                    if(sellPrice>goblinGoodsSkuInfoVo.getSellPrice().intValue()){
                                        sellPrice=goblinGoodsSkuInfoVo.getSellPrice().intValue();
                                    }
                                }
                            }
                            goblinGoodsInfoVo.setSellPrice(new BigDecimal(sellPrice));
                            goblinGoodsInfoVoArrayList.add(goblinGoodsInfoVo);
                        }
                    }else if(type.equals("s")){
                        //商铺活动的vo
                        GoblinStoreMarketVo goblinStoreMarketVo=goblinRedisUtils.getGoblinStoreMarketVo(idM);
                        if(!StringUtil.isNotBlank(goblinFrontSeckillVo.getStartTime())){
                            goblinFrontSeckillVo.setStartTime(goblinStoreMarketVo.getStartTime());
                            goblinFrontSeckillVo.setEndTime(goblinStoreMarketVo.getEndTime());
                        }
                        if(goblinStoreMarketVo==null){
                            break;
                        }
                        boolean isGet=false;
                        if(openBoolean){
                            //不做效验时间直接放true
                            isGet=true;
                        }else if(goblinStoreMarketVo.getIsPre()==1&&afterCalendar(goblinStoreMarketVo.getPreTime())&&beforeCalendar(goblinStoreMarketVo.getEndTime())){
                            isGet=true;
                        }else if(goblinStoreMarketVo.getIsPre()==0&&belongCalendar(goblinStoreMarketVo.getStartTime(),goblinStoreMarketVo.getEndTime())){
                            isGet=true;
                        }
                        if(isGet){
                            //获取商铺 对应关系
                            List<GoblinMarketRelationVo>  list1=goblinRedisUtils.getMarketRelation(GoblinStatusConst.MarketPreStatus.MARKET_PRE_PURCHASE.getValue(),goblinStoreMarketVo.getStoreMarketId());
                            //获得商品
                            //遍历 活动表
                            for(GoblinMarketRelationVo goblinMarketRelationVo:list1){
                                //找到对应的spu商品
                                GoblinGoodsInfoVo goblinGoodsInfoVo=goblinRedisUtils.getGoodsInfoVo(goblinMarketRelationVo.getSpuId());
                                //遍历sku 找到
                                List<String> skuList=goblinMarketRelationVo.getSkuList();
                                int sellPrice=0;
                                int i=0;
                                for(String skuId:skuList){
                                    GoblinGoodsSkuInfoVo goblinGoodsSkuInfoVo= goblinRedisUtils.getGoodsSkuInfoVo(skuId);
                                    if(null!=goblinGoodsSkuInfoVo){
                                        if(i==0){
                                            sellPrice=goblinGoodsSkuInfoVo.getSellPrice().intValue();
                                        }
                                        if(sellPrice>goblinGoodsSkuInfoVo.getSellPrice().intValue()){
                                            sellPrice=goblinGoodsSkuInfoVo.getSellPrice().intValue();
                                        }
                                    }
                                }
                                goblinGoodsInfoVo.setSellPrice(new BigDecimal(sellPrice));
                                goblinGoodsInfoVoArrayList.add(goblinGoodsInfoVo);
                            }
                        }

                    }
                }
                goblinFrontSeckillVo.setGoblinGoodsInfoVoList(goblinGoodsInfoVoArrayList);
            }


        }
        return ResponseDto.success( goblinFrontSeckillVo);
    }

    public  boolean belongCalendar( String startString, String  endString) throws ParseException {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(DateUtil.DATE_FULL_STR);//注意月份是MM
        Date from = simpleDateFormat.parse(startString);
        Date end= simpleDateFormat.parse(endString);
        Calendar date = Calendar.getInstance();
        date.setTime(new Date());
        Calendar after = Calendar.getInstance();
        after.setTime(from);
        Calendar before = Calendar.getInstance();
        before.setTime(end);
        if (date.after(after) && date.before(before)) {
            return true;
        } else {
            return false;
        }
    }
    //判断是否是该时间之后
    public boolean afterCalendar(String time) throws ParseException {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(DateUtil.DATE_FULL_STR);//注意月份是MM
        Calendar date = Calendar.getInstance();
        date.setTime(new Date());
        Date timefrom = simpleDateFormat.parse(time);
        if (date.after(timefrom)) {
            return true;
        } else {
            return false;
        }
    }
    //判断是否是该时间之后
    public boolean beforeCalendar(String time) throws ParseException {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(DateUtil.DATE_FULL_STR);//注意月份是MM
        Calendar date = Calendar.getInstance();
        date.setTime(new Date());
        Date timefrom = simpleDateFormat.parse(time);
        if (date.before(timefrom)) {
            return true;
        } else {
            return false;
        }
    }



}
