package com.liquidnet.service.goblin.service.impl;

import com.liquidnet.commons.lang.util.CollectionUtil;
import com.liquidnet.commons.lang.util.CurrentUtil;
import com.liquidnet.commons.lang.util.DateUtil;
import com.liquidnet.commons.lang.util.IDGenerator;
import com.liquidnet.service.adam.dto.vo.AdamAddressesVo;
import com.liquidnet.service.adam.dto.vo.AdamEntersVo;
import com.liquidnet.service.adam.dto.vo.AdamRscPolymer01Vo;
import com.liquidnet.service.base.ErrorMapping;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.goblin.constant.GoblinStatusConst;
import com.liquidnet.service.goblin.dto.manage.GoblinOrderParam;
import com.liquidnet.service.goblin.dto.manage.GoblinOrderSkuParam;
import com.liquidnet.service.goblin.dto.manage.GoblinOrderSpuParam;
import com.liquidnet.service.goblin.dto.manage.vo.GoblinPayInnerResultVo;
import com.liquidnet.service.goblin.dto.vo.GoblinGoodsInfoVo;
import com.liquidnet.service.goblin.dto.vo.GoblinGoodsSkuInfoVo;
import com.liquidnet.service.goblin.service.IGoblinAppOrderService;
import com.liquidnet.service.goblin.service.IGoblinAppZhengzaiService;
import com.liquidnet.service.goblin.util.*;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

@Service
@Slf4j
public class GoblinAppOrderServiceImpl implements IGoblinAppOrderService {

    @Autowired
    GoblinRedisUtils redisUtils;
    @Autowired
    GoblinMongoUtils mongoUtils;
    @Autowired
    QueueUtils queueUtils;
    @Autowired
    GoblinOrderUtils orderUtils;

    @Override
    public ResponseDto<GoblinPayInnerResultVo> checkOrder(GoblinOrderParam param) {
        boolean isDownGeneral = false; //是否需要回滚库存
        List<AdamEntersVo> entersVoList = ObjectUtil.cloneArrayListObject();
        String uid = CurrentUtil.getCurrentUid();
        List<String> skuAndPreListAndNumber = CollectionUtil.arrayListString();
        try {
            String orderMasterCode = IDGenerator.storeMasterCode();//总订单id
            List<GoblinOrderSpuParam> goblinOrderSpuParamList = param.getGoblinOrderSpuParamList();//分订单
            //获取用户相关
            String addressId;
            if (param.getAddressIds() == null || param.getAddressIds().size() == 0) {
                addressId = "";
            } else {
                addressId = StringUtils.join(param.getAddressIds(), ",");
            }
            AdamRscPolymer01Vo userVo = orderUtils.adamAddressEnterMember(uid, null, addressId);
            AdamAddressesVo addressesVo;
            boolean isMember;
            if (userVo == null) {
                isMember = false;
                addressesVo = null;
            } else {
                addressesVo = userVo.getAddressesVo();
                switch (userVo.getMembership()) {
                    case 10:
                    case 11:
                        isMember = true;
                        break;
                    default:
                        isMember = false;
                        break;
                }
            }
            for (GoblinOrderSpuParam spuParam : goblinOrderSpuParamList) {
                String orderId = IDGenerator.nextSnowId();
                String orderCode = IDGenerator.storeCode(orderId);
                String spuId = spuParam.getSpuId();
                GoblinGoodsInfoVo goblinGoodsInfoVo = redisUtils.getGoodsInfoVo(spuId);
                if (goblinGoodsInfoVo == null) {
                    return null;//参数异常
                }
                if (!(goblinGoodsInfoVo.getStatus().equals("3") && goblinGoodsInfoVo.getShelvesStatus().equals("3"))) {
                    return null;//该spu不可购买
                }
                String storeId = goblinGoodsInfoVo.getStoreId();
                String platVoucherCode = spuParam.getPlatVoucherCode();
                String storeVoucherCode = spuParam.getStoreVoucherCode();
                for (GoblinOrderSkuParam skuParam : spuParam.getGoblinOrderSkuParamArrayList()) {
                    String skuId = skuParam.getSkuIds();
                    int number = skuParam.getNumber();
                    if (!goblinGoodsInfoVo.getSkuIdList().contains(skuId)) {
                        return null;//参数异常
                    }
                    GoblinGoodsSkuInfoVo skuVo = redisUtils.getGoodsSkuInfoVo(skuId);
                    if (!(skuVo.getStatus().equals("3") && skuVo.getShelvesStatus().equals("3"))) {
                        return null;//该sku不可购买
                    }
                    // 判断库存
                    String pre = GoblinStatusConst.MarketPreStatus.getPre(skuId);
                    int limitCount = skuVo.getBuyLimit() == 0 ? Integer.MAX_VALUE : skuVo.getBuyLimit();
                    int surplusGeneral = redisUtils.decrSkuStock(pre, skuId, number);
                    if (surplusGeneral < 0) {//库存回滚
                        redisUtils.incrSkuStock(pre, skuId, number);
                        return null;//售罄
                    } else {
                        skuAndPreListAndNumber.add(skuId + "," + pre + "," + number);
                        isDownGeneral = true;
                        //判断限购
                        String res1 = orderUtils.judgeOrderLimit(uid, skuId, number, limitCount);
                        if (!res1.equals("")) {
                            redisUtils.incrSkuStock(pre, skuId, number);
                            return ResponseDto.failure(res1);//乱七八糟异常
                        }
                        //下单
                        isDownGeneral = false;
                        return null;
                    }
                }//GoblinOrderSkuParam
            }//GoblinOrderSpuParam
            return null;//参数异常
        } catch (Exception e) {
            log.error("Kylin Order Pay Error = {}", e);
            if (isDownGeneral) {
                //回顾限购 回滚库存
                for (String item : skuAndPreListAndNumber) {
                    String[] array = item.split(",");
                    String skuId = array[0];
                    String pre = array[1];
                    int number = Integer.parseInt(array[2]);
                    redisUtils.incrSkuStock(pre, skuId, number);
                    redisUtils.decrSkuCountByUid(uid, skuId, number);
                }
                log.error("回滚库存");
            }
            if (e.getMessage() == null) {
                return ResponseDto.failure(ErrorMapping.get("20018"));//乱七八糟异常
            } else if (e.getMessage().equals("券不可用")) {
                return ResponseDto.failure(ErrorMapping.get("20030"));//券不可用
            } else {
                return ResponseDto.failure(ErrorMapping.get("20018"));//乱七八糟异常
            }
        }
    }
}
