package com.liquidnet.service.goblin.util;

import com.fasterxml.jackson.core.type.TypeReference;
import com.liquidnet.commons.lang.util.CollectionUtil;
import com.liquidnet.commons.lang.util.HttpUtil;
import com.liquidnet.commons.lang.util.JsonUtils;
import com.liquidnet.service.adam.dto.vo.AdamRscPolymer01Vo;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.goblin.constant.GoblinStatusConst;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;

@Component
@Slf4j
public class GoblinOrderUtils {

    @Value("${liquidnet.adam.url}")
    private String adamUrl;
    @Value("${liquidnet.candy.url}")
    private String candyUrl;
    @Value("${liquidnet.service.stone.url}")
    private String stoneUrl;
    @Autowired
    GoblinRedisUtils redisUtils;

    public AdamRscPolymer01Vo adamAddressEnterMember(String uid, String enterIds, String addressId) {
        try {
            MultiValueMap<String, String> header = CollectionUtil.linkedMultiValueMapStringString();
            header.add("Accept", "application/json;charset=UTF-8");
            MultiValueMap<String, String> params = CollectionUtil.linkedMultiValueMapStringString();
            params.add("addressId", addressId);
            params.add("entersIds", enterIds);
            params.add("uid", uid);
            String resultData = HttpUtil.post(adamUrl + "/adam/rsc/inquire/of_buy_ticket", params, header);
            ResponseDto<AdamRscPolymer01Vo> vo = JsonUtils.fromJson(resultData, new TypeReference<ResponseDto<AdamRscPolymer01Vo>>() {
            });
            if (null != vo.getData()) {
                return vo.getData();
            } else {
                return null;
            }
        } catch (Exception e) {
            log.error("获取用户信息,e:{}", e);
            e.printStackTrace();
            return null;
        }
    }

    public String judgeOrderLimit(String uid, String skuId, int number, int limitCount) {
        int buyCount = redisUtils.getSkuCountByUid(uid, skuId);
        if (buyCount + number > limitCount) {
            return "已超出限购数量";
        } else {
            redisUtils.incrSkuCountByUid(uid, skuId, number);
            return "";
        }
    }
}
