package com.liquidnet.service.goblin.service.impl.manage;

import com.github.pagehelper.PageInfo;
import com.liquidnet.commons.lang.util.DateUtil;
import com.liquidnet.commons.lang.util.IDGenerator;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.goblin.dto.manage.GoblinStorePurchaseItemParam;
import com.liquidnet.service.goblin.dto.vo.GoblinStoreMarketVo;
import com.liquidnet.service.goblin.entity.GoblinStoreMarketPurchasing;
import com.liquidnet.service.goblin.entity.GoblinStoreMarketing;
import com.liquidnet.service.goblin.service.manage.IGoblinStorePurchasingService;
import com.liquidnet.service.goblin.util.GoblinMongoUtils;
import com.liquidnet.service.goblin.util.GoblinRedisUtils;
import me.chanjar.weixin.common.util.DataUtils;
import org.apache.commons.lang.time.DateUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.List;

import static com.liquidnet.commons.lang.util.DateUtil.DTF_YMD_HMS;

@Service
public class GoblinStorePurchasingServiceImpl implements IGoblinStorePurchasingService {

    @Autowired
    GoblinRedisUtils goblinRedisUtils;
    @Autowired
    GoblinMongoUtils goblinMongoUtils;

    @Override
    public ResponseDto<PageInfo<GoblinStoreMarketVo>> purchasingList(int page, String purchaseName, int status, String st, String et, String ct) {
        PageInfo pageInfo = new PageInfo();
        LocalDateTime now = LocalDateTime.now();
        HashMap<String, Object> map = goblinMongoUtils.getStoreMarketList(page, purchaseName, status, st, et, ct);
        List<GoblinStoreMarketVo> list = (List<GoblinStoreMarketVo>) map.get("data");
        for (GoblinStoreMarketVo item : list) {
            if (LocalDateTime.parse(item.getStartTime(), DTF_YMD_HMS).isAfter(now)) {
                item.setStatus(0);
            } else if (LocalDateTime.parse(item.getEndTime(), DTF_YMD_HMS).isBefore(now)) {
                item.setStatus(2);
            } else {
                item.setStatus(1);
            }
        }
        pageInfo.setList(list);
        pageInfo.setTotal((Long) map.get("total"));
        return ResponseDto.success(pageInfo);
    }

    @Override
    public ResponseDto<Boolean> purchasingStatus(String marketId, String storeId, int status) {
        GoblinStoreMarketing bean = GoblinStoreMarketing.getNew();
        LocalDateTime now = LocalDateTime.now();
        bean.setUpdatedAt(now);
        switch (status) {
            case 0:
            case 7:
                bean.setStatus(status);
                bean.setDelFlag(0);
                GoblinStoreMarketVo vo = GoblinStoreMarketVo.getNew();
                vo.setStatus(status);
                goblinMongoUtils.updateStoreMarket(marketId, storeId, vo);
                vo = goblinRedisUtils.getGoblinStoreMarketVo(marketId, storeId);
                vo.setStatus(status);
                goblinRedisUtils.setGoblinStoreMarketVo(marketId, storeId, vo);
                break;
            case -1:
                bean.setStatus(7);
                bean.setDelFlag(1);
                goblinMongoUtils.delStoreMarket(marketId, storeId);
                goblinRedisUtils.delGoblinStoreMarketVo(marketId, storeId);
                break;
        }
        //mysql todo
        return ResponseDto.success();
    }

    @Override
    public ResponseDto<Boolean> purchasingInsert(String purchaseName, String storeId, String st, String et, Integer isPre, String preTime) {
        String storeMarketId = IDGenerator.nextTimeId2();
        GoblinStoreMarketing bean = GoblinStoreMarketing.getNew();
        bean.setStoreMarketId(storeMarketId);
        bean.setName(purchaseName);
        bean.setType(2);
        bean.setStatus(0);
        bean.setStoreId(storeId);
        bean.setDescribes("");
        bean.setStartTime(LocalDateTime.parse(st, DTF_YMD_HMS));
        bean.setEndTime(LocalDateTime.parse(et, DTF_YMD_HMS));
        bean.setDelFlag(0);
        bean.setIsPre(isPre);
        if (isPre == 1) {
            bean.setPreTime(LocalDateTime.parse(preTime, DTF_YMD_HMS));
        }
        bean.setCreatedAt(LocalDateTime.now());

        GoblinStoreMarketVo vo = GoblinStoreMarketVo.getNew();
        BeanUtils.copyProperties(bean, vo);
        vo.setStartTime(st);
        vo.setEndTime(et);
        vo.setCreatedAt(DateUtil.getNowTime());
        vo.setPreTime(preTime);
        //mongo
        goblinMongoUtils.insertStoreMarket(vo);
        //redis
        goblinRedisUtils.setGoblinStoreMarketVo(storeMarketId, storeId, vo);
        //mysql todo
        return ResponseDto.success();
    }

    @Override
    public ResponseDto<Boolean> purchasingUpdate(String marketId, String purchaseName, String storeId, String st, String et, Integer isPre, String preTime) {
        GoblinStoreMarketing bean = GoblinStoreMarketing.getNew();
        bean.setName(purchaseName);
        bean.setType(2);
        bean.setStatus(0);
        bean.setStoreId(storeId);
        bean.setDescribes("");
        bean.setStartTime(LocalDateTime.parse(st, DTF_YMD_HMS));
        bean.setEndTime(LocalDateTime.parse(et, DTF_YMD_HMS));
        bean.setDelFlag(0);
        bean.setIsPre(isPre);
        if (isPre == 1) {
            bean.setPreTime(LocalDateTime.parse(preTime, DTF_YMD_HMS));
        }else{
            bean.setPreTime(null);
        }
        bean.setUpdatedAt(LocalDateTime.now());

        GoblinStoreMarketVo vo = GoblinStoreMarketVo.getNew();
        BeanUtils.copyProperties(bean, vo);
        //mongo
        goblinMongoUtils.updateStoreMarket(marketId, storeId, vo);
        //redis
        goblinRedisUtils.setGoblinStoreMarketVo(marketId, storeId, vo);
        //mysql todo
        return ResponseDto.success();
    }

    @Override
    public ResponseDto<GoblinStoreMarketVo> purchasingDetails(String marketId, String storeId) {
        return ResponseDto.success(goblinRedisUtils.getGoblinStoreMarketVo(marketId, storeId));
    }

    @Override
    public ResponseDto<String> purchasingSkuList(String marketId, String storeId, int page) {
        return null;
    }

    @Override
    public ResponseDto<Boolean> purchasingSkuInsert(List<GoblinStorePurchaseItemParam> params) {
        String purchaseId = IDGenerator.nextMilliId2();
        LocalDateTime now = LocalDateTime.now();
        for (GoblinStorePurchaseItemParam item : params) {
            GoblinStoreMarketPurchasing bean = GoblinStoreMarketPurchasing.getNew();
            bean.setPurchaseId(purchaseId);
            bean.setStoreMarketId(item.getStoreMarketId());
            bean.setStoreId(item.getStoreId());
            bean.setSkuId(item.getSkuId());
            bean.setSpuId(item.getSpuId());
            bean.setPriceMarketing(item.getPriceMarketing());
            bean.setStockMarketing(item.hashCode());
            bean.setBuyLimit(item.getBuyLimit());
            bean.setBuyType(item.getBuyType());
            bean.setDelFlag(0);
            bean.setCreatedAt(now);
            //mongo
            //redis
        }

        //mysql
        return null;
    }

    @Override
    public ResponseDto<Boolean> purchasingSkuUpdate(List<GoblinStorePurchaseItemParam> params) {
        LocalDateTime now = LocalDateTime.now();
        for (GoblinStorePurchaseItemParam item : params) {
            GoblinStoreMarketPurchasing bean = GoblinStoreMarketPurchasing.getNew();
//            bean.setStoreMarketId(item.getStoreMarketId());
//            bean.setStoreId(item.getStoreId());
//            bean.setSkuId(item.getSkuId());
//            bean.setSpuId(item.getSpuId());
            bean.setPriceMarketing(item.getPriceMarketing());
            bean.setStockMarketing(item.hashCode());
            bean.setBuyLimit(item.getBuyLimit());
            bean.setBuyType(item.getBuyType());
            bean.setDelFlag(0);
            bean.setUpdatedAt(now);
            //mongo
            //redis
        }

        //mysql
        return null;
    }

    @Override
    public ResponseDto<Boolean> purchasingSkuDel(String marketId, String storeId, String spuId, String skuId) {
        LocalDateTime now = LocalDateTime.now();

        GoblinStoreMarketPurchasing bean = GoblinStoreMarketPurchasing.getNew();
        bean.setUpdatedAt(now);
        bean.setDelFlag(1);
        //mysql
        //mongo
        //redis
        return null;
    }
}
