package com.liquidnet.service.goblin.service.impl.manage;

import com.liquidnet.commons.lang.util.DateUtil;
import com.liquidnet.service.goblin.dto.vo.GoblinMarketingZhengzaiRelationVo;
import com.liquidnet.service.goblin.dto.vo.GoblinSelfMarketingVo;
import com.liquidnet.service.goblin.service.manage.IGoblinZhengzaiService;
import com.liquidnet.service.goblin.util.GoblinRedisUtils;
import com.liquidnet.service.goblin.util.ObjectUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

@Service
public class GoblinZhengzaiServiceImpl implements IGoblinZhengzaiService {

    @Autowired
    GoblinRedisUtils redisUtils;

    @Override
    public List<GoblinSelfMarketingVo> zhengzaiCanJoin(String storeId) {
        List<String> marketIds = redisUtils.getStoreZhengzaiRelation(storeId);
        List<GoblinSelfMarketingVo> voList = ObjectUtil.getGoblinSelfMarketingVoList();
        for (String selfMarketId : marketIds) {
            GoblinMarketingZhengzaiRelationVo zhengzaiRelationVo = redisUtils.getZhengzaiRelation(selfMarketId, storeId);
            if (DateUtil.compareStrDay(DateUtil.getNowTime(), zhengzaiRelationVo.getShowTime()) == 1) {
                voList.add(redisUtils.getSelfMarket(selfMarketId));
            }
        }
        return voList;
    }

    @Override
    public GoblinSelfMarketingVo zhengzaiCanJoinDetails(String marketId, String storeId) {
        GoblinMarketingZhengzaiRelationVo zhengzaiRelationVo = redisUtils.getZhengzaiRelation(marketId, storeId);
        if (DateUtil.compareStrDay(DateUtil.getNowTime(), zhengzaiRelationVo.getShowTime()) == 1) {
            return redisUtils.getSelfMarket(marketId);
        }
        return null;
    }

}
