package com.liquidnet.service.candy.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import java.io.Serializable;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * <p>
 * 券码信息
 * </p>
 *
 * @author liquidnet
 * @since 2021-08-18
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class CandyCouponCode implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "mid", type = IdType.AUTO)
    private Long mid;

    /**
     * 券码
     */
    private String ccode;

    /**
     * ~candy_coupon.coupon_id
     */
    private String couponId;

    /**
     * 状态[0-未使用|1-已使用|2-失效|3-退回]
     */
    private Integer state;

    /**
     * 兑换用户UID
     */
    private String usedUid;

    private LocalDateTime createdAt;

    private LocalDateTime updatedAt;

    /**
     * 兑换时间
     */
    private LocalDateTime redeemAt;

    private String comment;


}
