package com.liquidnet.service.goblin.controller;

import com.liquidnet.common.cache.redis.util.RedisUtil;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.goblin.constant.GoblinRedisConst;
import com.liquidnet.service.goblin.dto.vo.GoblinFrontBannerVo;
import com.liquidnet.service.goblin.entity.GoblinFrontBanner;
import com.liquidnet.service.goblin.entity.GoblinFrontHotWord;
import com.liquidnet.service.goblin.entity.GoblinFrontNavigation;
import com.liquidnet.service.goblin.entity.GoblinFrontSeckill;
import com.liquidnet.service.goblin.util.ObjectUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;

/**
 * @author zhangfuxin
 * @Description:前端接口
 * @date 2021/12/27 下午6:25
 */
@Api(tags = "前端接口管理")
@RestController
@RequestMapping("/front")
public class GoblinFrontController {
    @Autowired
    private RedisUtil redisUtil;

    @GetMapping("getBanner")
    @ApiOperation("获取banner")
    public ResponseDto getBanner() {
        List<GoblinFrontBanner> list= (List<GoblinFrontBanner>) redisUtil.get(GoblinRedisConst.FRONT_BANNER);
        LocalDateTime nowTime= LocalDateTime.now();
        ArrayList<GoblinFrontBanner> goblinFrontBannerArrayList=ObjectUtil.getGoblinFrontBannerArrayList();
        //查看是否有失效的时间
        for(GoblinFrontBanner goblinFrontBanner:list){
            if(null!=goblinFrontBanner.getEndTime()){
                if( nowTime.isAfter(goblinFrontBanner.getEndTime())){
                }else{
                    goblinFrontBannerArrayList.add(goblinFrontBanner);
                }
            }
        }
        ArrayList<GoblinFrontBannerVo> list1= ObjectUtil.goblinFrontBannerVoArrayList();
        for(GoblinFrontBanner goblinFrontBanner:goblinFrontBannerArrayList){
            GoblinFrontBannerVo goblinFrontBannerVo=GoblinFrontBannerVo.getNew();
            BeanUtils.copyProperties(goblinFrontBanner,goblinFrontBannerVo);
            list1.add(goblinFrontBannerVo);
        }

        //redis里获取banner
        return ResponseDto.success( list1);
    }
    @GetMapping("getHotWord")
    @ApiOperation("获得热词")
    public ResponseDto getHotWord() {
        int index= (int) redisUtil.get(GoblinRedisConst.FRONT_HOTWORD_INDEX);
        //获得value
        List<GoblinFrontHotWord> list= (List<GoblinFrontHotWord>) redisUtil.get(GoblinRedisConst.FRONT_HOTWORD);
        index++;
        String hotWord="";
        redisUtil.set(GoblinRedisConst.FRONT_HOTWORD_INDEX,index);
        if(index<list.size()){
            hotWord= list.get(index).getWord();
        }else{
            hotWord= list.get(0).getWord();
        }
        return ResponseDto.success( hotWord );
    }
    @GetMapping("getNavigation")
    @ApiOperation("获得金刚栏")
    public ResponseDto getNavigation() {
        List<GoblinFrontNavigation> list = (List<GoblinFrontNavigation>) redisUtil.get(GoblinRedisConst.FRONT_NAVIGATION);
        return ResponseDto.success( list );
    }

    @GetMapping("getSeckilll")
    @ApiOperation("获得秒杀首页要用的")
    public ResponseDto getSeckilll() {
        List<GoblinFrontSeckill> list= (List<GoblinFrontSeckill>) redisUtil.get(GoblinRedisConst.FRONT_SECKILL);
        //判断是否有
        if(null!=list&&list.size()>0){
            //

        }
        return ResponseDto.success( list );
    }





}
