package com.liquidnet.service.goblin.dto.vo;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalDateTimeDeserializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalDateTimeSerializer;
import com.liquidnet.commons.lang.util.DateUtil;
import com.liquidnet.service.goblin.entity.GoblinNftExSku;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.time.LocalDateTime;

/**
 * @Author: wll
 * @Description:
 * @Date:Create：in 2022/4/19 2:23 下午
 */

@Data
@EqualsAndHashCode(callSuper = false)
public class GoblinNftExSkuVo {


    private static final long serialVersionUID = 1L;

    @TableId(value = "mid", type = IdType.AUTO)
    private Long mid;


    /**
     * 活动id
     */
    @ApiModelProperty(position = 10,required = true,value ="活动id")
    private String activityId;

    /**
     * 商品id
     */
    @ApiModelProperty(position = 11,required = true,value ="商品id")
    private String spuId;


    /**
     * 款式id
     */
    @ApiModelProperty(position = 12,required = true,value ="款式id")
    private String skuId;

    /**
     * 是否盲盒 0：否   1：是
     */
    @ApiModelProperty(position = 13,required = true,value ="是否盲盒 0：否   1：是")
    private String unBox;

    /**
     * 店铺id
     */
    @ApiModelProperty(position = 14,required = true,value ="店铺id")
    private String storeId;


    /**
     * 兑换库存
     */
    @ApiModelProperty(position = 15,required = true,value =" 兑换库存")
    private Integer exStock;

    /**
     * 兑换限购
     */
    @ApiModelProperty(position = 16,required = true,value ="兑换限购")
    private Integer exLimit;


    /**
     * 兑换生效开始时间
     */
    @JsonDeserialize(using = LocalDateTimeDeserializer.class)
    @JsonSerialize(using = LocalDateTimeSerializer.class)
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = DateUtil.DATE_FULL_STR)
    @ApiModelProperty(position = 17,required = true,value ="兑换生效开始时间")
    private LocalDateTime exStartTime;


    /**
     * 兑换生效结束时间
     */
    @JsonDeserialize(using = LocalDateTimeDeserializer.class)
    @JsonSerialize(using = LocalDateTimeSerializer.class)
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = DateUtil.DATE_FULL_STR)
    @ApiModelProperty(position = 18,required = true,value ="兑换生效结束时间")
    private LocalDateTime exStopTime;

    /**
     * 创建时间
     */
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = DateUtil.DATE_FULL_STR)
    @ApiModelProperty(position = 19,required = true,value ="创建时间")
    private LocalDateTime createdAt;

    /**
     * 修改时间
     */
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = DateUtil.DATE_FULL_STR)
    @ApiModelProperty(position = 20,required = true,value ="修改时间")
    private LocalDateTime updatedAt;

    private String rdStartTime;
    private String rdStopTime;

    private  static  final GoblinNftExSkuVo obj = new GoblinNftExSkuVo();

    public  static GoblinNftExSkuVo getNew(){
        try{
           return  (GoblinNftExSkuVo) obj.clone();
        }catch (CloneNotSupportedException e){
            return new GoblinNftExSkuVo();
        }
    }



    public GoblinNftExSkuVo copy(GoblinNftExSku goblinNftExSku){
        if (null == goblinNftExSku) return this;
        this.setActivityId(goblinNftExSku.getActivityId());
        this.setSpuId(goblinNftExSku.getSpuId());
        this.setSkuId(goblinNftExSku.getSkuId());
        this.setUnBox(goblinNftExSku.getUnbox());
        this.setStoreId(goblinNftExSku.getStoreId());
        this.setExStock(goblinNftExSku.getExStock());
        this.setExLimit(goblinNftExSku.getExLimit());
        this.setExStartTime(goblinNftExSku.getExStartTime());
        this.setExStopTime(goblinNftExSku.getExStopTime());
        this.setCreatedAt(goblinNftExSku.getCreatedAt());
        this.setUpdatedAt(goblinNftExSku.getUpdatedAt());
        return this;
    }














}
