package com.liquidnet.service.galaxy.constant;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: TODO
 * @class: GalaxyConstant
 * @Package com.liquidnet.service.galaxy.constant
 * @Copyright: LightNet @ Copyright (c) 2022
 * @date 2022/3/23 12:25
 */
public class GalaxyEnum {
    public enum RouterTypeEnum{
        ZXINCHAIN("zxinchain","至信链"),
        ETH ("eth","以太坊"),
        ANTCHAIN ("antchain","蚂蚁链"),
        XUPER("xuper","百度超级链");
        private String code;
        private String message;
        RouterTypeEnum(String code, String message) {
            this.code = code;
            this.message = message;
        }

        public String getCode() {
            return code;
        }
    }


    /**
     * 路由业务枚举
     */
    public enum SeriesClaimStatusEnum{
        SERIES_INIT("init","系列声明数据初始化"),
        PROCESSING("processing","系列声明中"),
        SUCCESS ("success","系列声明成功"),
        FAIL ("fail","系列声明失败");
        private String code;
        private String message;
        SeriesClaimStatusEnum(String code, String message) {
            this.code = code;
            this.message = message;
        }

        public String getCode() {
            return code;
        }
    }

    /**
     * 路由业务枚举
     */
    public enum RouterBusinessEnum{
        NFT("nft","数字藏品nft"),
        DCI ("dci","数字存证dci");
        private String code;
        private String message;
        RouterBusinessEnum(String code, String message) {
            this.code = code;
            this.message = message;
        }

        public String getCode() {
            return code;
        }
    }


    public enum DeviceFromEnum{
        WEB("web",""),
        WAP("wap",""),
        WAPPAGE("wappage",""),
        APP("app",""),
        JS("js",""),
        APPLET("applet","");
        private String code;
        private String message;
        DeviceFromEnum(String code, String message) {
            this.code = code;
            this.message = message;
        }
        public String getCode() {
            return code;
        }
    }

    /**
     * 注册类型
     */
    public enum RegisterTypeEnum{
        PERSON("1","企业"),
        COMPANY("2","个人");


        private String code;
        private String message;
        RegisterTypeEnum(String code, String message) {
            this.code = code;
            this.message = message;
        }

        public RegisterTypeEnum getEnumByCode(String code){
            RegisterTypeEnum[] arry = RegisterTypeEnum.values();
            for (int i = 0; i < arry.length; i++) {
                if (arry[i].getCode().equals(code)) {
                    return arry[i];
                }
            }
            return null;
        }

        public String getCode() {
            return code;
        }
    }

    public enum CardTypeEnum{
        //         1-身份证 2-护照 3-港澳通行证 4-台湾通行证 5-外国人永居身份证 6-港澳台居民居住证 7-其它
        ID_CARD("1","身份证"),
        ID_CARD_PP("2","护照"),
        ID_CARD_HM("3","港澳通行证"),
        ID_CARD_TW("4","台湾通行证"),
        ID_CARD_FOR("5","外国人永居身份证"),
        ID_CARD_HMTW("6","港澳台居民居住证"),
        ID_CARD_OTHER("7","其它");


        private String code;
        private String message;
        CardTypeEnum(String code, String message) {
            this.code = code;
            this.message = message;
        }

        public CardTypeEnum getEnumByCode(String code){
            CardTypeEnum[] arry = CardTypeEnum.values();
            for (int i = 0; i < arry.length; i++) {
                if (arry[i].getCode().equals(code)) {
                    return arry[i];
                }
            }
            return null;
        }

        public String getCode() {
            return code;
        }
    }

    /**
     * 标记任务状态
     */
    public enum TaskStatusEnum{
        INIT("-1","数据初始化"),
        PROCESSING("0","任务执行中"),
        TASK_SUCCESS("1","任务成功"),
        TASK_FAIL("2","任务失败");


        private String code;
        private String message;
        TaskStatusEnum(String code, String message) {
            this.code = code;
            this.message = message;
        }

        public TaskStatusEnum getEnumByCode(String code){
            TaskStatusEnum[] arry = TaskStatusEnum.values();
            for (int i = 0; i < arry.length; i++) {
                if (arry[i].getCode().equals(code)) {
                    return arry[i];
                }
            }
            return null;
        }

        public String getCode() {
            return code;
        }

        public String getMessage(){
            return message;
        }
    }

    /**
     * 标记任务状态
     */
    public enum UserBindStatusEnum{
        BIND_PROCESSING("0","绑定中"),
        BIND_SUCCESS("1","已绑定"),
        BIND_FAIL("2","绑定失败"),
        BIND_CANNOT_QUERY("3","未发起过绑定(未查询到)");


        private String code;
        private String message;
        UserBindStatusEnum(String code, String message) {
            this.code = code;
            this.message = message;
        }

        public UserBindStatusEnum getEnumByCode(String code){
            UserBindStatusEnum[] arry = UserBindStatusEnum.values();
            for (int i = 0; i < arry.length; i++) {
                if (arry[i].getCode().equals(code)) {
                    return arry[i];
                }
            }
            return null;
        }

        public String getCode() {
            return code;
        }

        public String getMessage(){
            return message;
        }
    }

    /**
     * 交易类别
     */
    public enum TradeTypeEnum{
        TRADE_PUBLISH("1","发行"),
        TRADE_BUY("2","购买"),
        TRADE_TRANSFER("3","转移"),
        TRADE_SET_PRICE("4","设置价格"),
        TRADE_SET_STATUS("5","设置状态");


        private String code;
        private String message;
        TradeTypeEnum(String code, String message) {
            this.code = code;
            this.message = message;
        }

        public TradeTypeEnum getEnumByCode(String code){
            TradeTypeEnum[] arry = TradeTypeEnum.values();
            for (int i = 0; i < arry.length; i++) {
                if (arry[i].getCode().equals(code)) {
                    return arry[i];
                }
            }
            return null;
        }

        public String getCode() {
            return code;
        }

        public String getMessage(){
            return message;
        }
    }


    public static void main(String[] args) {
        Integer aaa = 1;
        if(aaa.toString().equals(RouterTypeEnum.ZXINCHAIN.getCode())){
            System.out.println("支付成功");
        }
    }
}
