package com.liquidnet.service.consumer.kylin.utils;

import com.liquidnet.common.cache.redis.util.RedisUtil;
import com.liquidnet.service.galaxy.utils.AbstractDataUtils;
import com.liquidnet.service.galaxy.utils.QueueUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.stereotype.Component;

@Slf4j
@Component
public class DataUtils extends AbstractDataUtils {
    @Autowired
    private RedisUtil redisUtil;

    @Autowired
    private MongoTemplate mongoTemplate;

    @Autowired
    private QueueUtil queueUtil;

    private long keyExpireTime = 3600*24*30;


    @Override
    public RedisUtil getRedisUtil() {
        return redisUtil;
    }

    @Override
    public MongoTemplate getMongoTemplate() {
        return mongoTemplate;
    }

    @Override
    public com.liquidnet.service.galaxy.utils.QueueUtil getQueueUtil() {
        return queueUtil;
    }
}
