package com.liquidnet.service.galaxy.dto.param;

import com.liquidnet.commons.lang.util.JsonUtils;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: NFT转让返回
 * @class: GalaxyNftTransferRespDto
 * @Package com.liquidnet.service.galaxy.dto.param;
 * @Copyright: LightNet @ Copyright (c) 2022
 * @date 2022/8/12 18:51
 */
@ApiModel(value = "GalaxyNftTransferRespDto", description = "NFT转让结果")
@Data
public class GalaxyNftTransferRespDto implements Serializable,Cloneable {
    @ApiModelProperty(position = 1, required = true, value = "拥有者用户ID")
    private String ownerUserId;

    @ApiModelProperty(position = 1, required = true, value = "转让者用户ID")
    private String fromUserId;

    @ApiModelProperty(position = 1, required = true, value = "转让时间")
    private String transferTime;

    @Override
    public String toString(){
        return JsonUtils.toJson(this);
    }

    private static final GalaxyNftTransferRespDto obj = new GalaxyNftTransferRespDto();

    public static GalaxyNftTransferRespDto getNew() {
        try {
            return (GalaxyNftTransferRespDto) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new GalaxyNftTransferRespDto();
        }
    }
}
