package com.liquidnet.service.galaxy.dto.param;

import com.liquidnet.commons.lang.util.JsonUtils;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: NFT转让结果查询
 * @class: GalaxyNftTransferQueryRespDto
 * @Package com.liquidnet.service.galaxy.dto.param;
 * @Copyright: LightNet @ Copyright (c) 2022
 * @date 2022/8/4 18:51
 */
@ApiModel(value = "GalaxyNftTransferQueryRespDto", description = "NFT转让结果查询")
@Data
public class GalaxyNftTransferQueryRespDto implements Serializable,Cloneable {
    @ApiModelProperty(position = 1, required = true, value = "用户Id")
    private String userId;

    @ApiModelProperty(position = 1, required = true, value = "用户购买的nftId")
    private String nftId;

    @Override
    public String toString(){
        return JsonUtils.toJson(this);
    }

    private static final GalaxyNftTransferQueryRespDto obj = new GalaxyNftTransferQueryRespDto();

    public static GalaxyNftTransferQueryRespDto getNew() {
        try {
            return (GalaxyNftTransferQueryRespDto) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new GalaxyNftTransferQueryRespDto();
        }
    }
}
