package com.liquidnet.service.goblin.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

@ApiModel(value = "GoblinStoreSearchDto", description = "商品搜素")
@Data
public class GoblinGoodsSearchDto implements Serializable, Cloneable {
    private static final long serialVersionUID = 8425727558228094904L;
    @ApiModelProperty(position = 11, value = "店铺id")
    private String spuId;
    @ApiModelProperty(position = 11, value = "店铺名称")
    private String spuName;

    private static final GoblinGoodsSearchDto obj = new GoblinGoodsSearchDto();
    public static GoblinGoodsSearchDto getNew() {
        try {
            return (GoblinGoodsSearchDto) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new GoblinGoodsSearchDto();
        }
    }
}
