package com.liquidnet.service.consumer.kylin.receiver;

import com.liquidnet.commons.lang.util.CollectionUtil;
import com.liquidnet.commons.lang.util.HttpUtil;
import com.liquidnet.commons.lang.util.JsonUtils;
import com.liquidnet.service.base.constant.MQConst;
import com.liquidnet.service.goblin.dto.GoblinQueueBizIntegralDto;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.connection.stream.StreamRecords;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;

import java.util.HashMap;

@Slf4j
@Component
public class ConsumerGoblinBizIntegralReceiver extends AbstractBizRedisReceiver {

    @Value("${liquidnet.service.stone.url}")
    private String stoneUrl;

    @Override
    protected String getRedisStreamKey() {
        return MQConst.GoblinQueue.BIZ_INTEGRAL.getKey();
    }

    @Override
    protected String getRedisStreamGroup() {
        return MQConst.GoblinQueue.BIZ_INTEGRAL.getGroup();
    }

    @Override
    protected boolean consumerMessageHandler(String msg) {
        boolean aBoolean = false;
        try {
            GoblinQueueBizIntegralDto fromJsonObj = JsonUtils.fromJson(msg, GoblinQueueBizIntegralDto.class);
            if (fromJsonObj == null) {
                log.warn("CONSUMER MSG NULL_DTO ==> [{}]:{}", this.getRedisStreamKey(), msg);
                aBoolean = true;
            } else {
                aBoolean = this.bizIntegralProcessing(fromJsonObj);
            }
        } catch (Exception e) {
            log.error("CONSUMER MSG EX_HANDLE ==> [{}]:{}", this.getRedisStreamKey(), msg, e);
        } finally {
            if (!aBoolean) {
                HashMap<String, String> map = CollectionUtil.mapStringString();
                map.put(MQConst.QUEUE_MESSAGE_KEY, msg);
                stringRedisTemplate.opsForStream().add(StreamRecords.mapBacked(map).withStreamKey(this.getRedisStreamKey()));
            }
        }
        return aBoolean;
    }

    private boolean bizIntegralProcessing(GoblinQueueBizIntegralDto dto) {
        try {
            log.info("bizIntegralProcessing params:{}", dto);
            String uid = dto.getUid(), content = dto.getContent();
            int type = dto.getType();
            MultiValueMap<String, String> header = CollectionUtil.linkedMultiValueMapStringString();
            header.add("Accept", "application/json;charset=UTF-8");
            MultiValueMap<String, String> params = CollectionUtil.linkedMultiValueMapStringString();
            params.add("score", dto.getScore().intValue() + "");
            params.add("content", content);
            params.add("uid", uid);
            String resultData = "";
            if (type == 1) {
                resultData = HttpUtil.post(stoneUrl + "/user/logs/in2111", params, header);
            } else {
                resultData = HttpUtil.post(stoneUrl + "/user/logs/de2111", params, header);
            }
            log.info("bizIntegralProcessing result:{}", resultData);
            return true;
        } catch (Exception e) {
            log.error("bizIntegralProcessing e:{}", e);
            return false;
        }
    }

    /* ------------------------------------------------------------------------------------ */
}
