package com.liquidnet.service.sweet.vo;

import com.liquidnet.service.sweet.entity.SweetDoudouActive;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

@Data
@ApiModel("SweetDouDouActiveVo")
public class SweetDouDouActiveVo implements Serializable, Cloneable {

    @ApiModelProperty("doudou_id")
    private String doudouId;

    @ApiModelProperty("user_id")
    private String userId;

    @ApiModelProperty("活动ID")
    private String activeId;

    @ApiModelProperty("标题")
    private String title;

    @ApiModelProperty("活动详情")
    private String details;

    @ApiModelProperty("卡片背景图")
    private String cardImages;

    @ApiModelProperty("活动详情背景图")
    private String detailImages;

    @ApiModelProperty("活动详情URL")
    private String targetUrl;

    @ApiModelProperty("活动状态：2：进行中 3：已结束")
    private Integer activeStatus;

    @ApiModelProperty("状态 0未登记 1已登记 2未中签 3已中签 4已核销")
    private Integer status;

    private static final SweetDouDouActiveVo obj = new SweetDouDouActiveVo();


    public static SweetDouDouActiveVo getNew() {
        try {
            return (SweetDouDouActiveVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new SweetDouDouActiveVo();
        }
    }

    public SweetDouDouActiveVo copy(SweetDoudouActive source) {
        if (null == source) return this;
        this.activeId = source.getActiveId();
        this.title = source.getTitle();
        this.cardImages = source.getCardImages();
        this.detailImages = source.getDetailImages();
        this.targetUrl = source.getTargetUrl();
        this.details = source.getDetails();
        return this;
    }

}
