package com.liquidnet.client.admin.web.controller.zhengzai.adam;

import com.liquidnet.client.admin.common.core.controller.BaseController;
import com.liquidnet.client.admin.common.core.page.TableDataInfo;
import com.liquidnet.client.admin.zhengzai.adam.service.IAdamMemberOrderAdminService;
import com.liquidnet.service.adam.dto.MemberOrderDto;
import com.liquidnet.service.adam.dto.param.admin.MemberOrderListReq;
import com.liquidnet.service.adam.dto.vo.admin.MemberOrderDetailAdminVo;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: 会员订单Controller
 * @class: Test
 * @Package com.liquidnet.client.admin.web.controller.zhengzai.adam
 * @Copyright: LightNet @ Copyright (c) 2021
 * @date 2021/6/6 16:52
 */
@Controller
@RequestMapping("adam/order")
public class AdamMemberOrderController extends BaseController
{
    private String prefix = "zhengzai/adam/order";

    @Autowired
    private IAdamMemberOrderAdminService adamMemberOrderAdminService;

    @RequiresPermissions("adam:order:orderlist:view")
    @GetMapping("/orderList")
    public String order()
    {
        return prefix + "/orderList/order";
    }

    /**
     * 查询【请填写功能名称】列表
     */
    @RequiresPermissions("adam:order:orderlist:list")
    @PostMapping("/orderList/list")
    @ResponseBody
    public TableDataInfo list(MemberOrderListReq memberOrderListReq)
    {
        startPage();
        List<MemberOrderDto> list = adamMemberOrderAdminService.getMemberOrderList(memberOrderListReq);
        return getDataTable(list);
    }

    /**
     * 订单详情
     */
    @RequiresPermissions("adam:order:orderlist:detail")
    @GetMapping("/orderList/detail/{orderId}")
    public String orderDetail(@PathVariable("orderId") String orderId, ModelMap mmap) {
        MemberOrderDetailAdminVo orderDetailsVo = adamMemberOrderAdminService.getMemberOrderDetail(orderId);
        mmap.put("orderDetailsVo", orderDetailsVo);
        return prefix + "/orderList/detail";
    }

//    /**
//     * 导出【请填写功能名称】列表
//     */
//    @RequiresPermissions("adam:order:export")
//    @Log(title = "【请填写功能名称】", businessType = BusinessType.EXPORT)
//    @PostMapping("/export")
//    @ResponseBody
//    public AjaxResult export(AdamMemberOrder adamMemberOrder)
//    {
//        List<AdamMemberOrder> list = adamMemberOrderService.selectAdamMemberOrderList(adamMemberOrder);
//        ExcelUtil<AdamMemberOrder> util = new ExcelUtil<AdamMemberOrder>(AdamMemberOrder.class);
//        return util.exportExcel(list, "【请填写功能名称】数据");
//    }

//    /**
//     * 新增【请填写功能名称】
//     */
//    @GetMapping("/add")
//    public String add()
//    {
//        return prefix + "/add";
//    }

//    /**
//     * 新增保存【请填写功能名称】
//     */
//    @RequiresPermissions("adam:order:add")
//    @Log(title = "【请填写功能名称】", businessType = BusinessType.INSERT)
//    @PostMapping("/add")
//    @ResponseBody
//    public AjaxResult addSave(AdamMemberOrder adamMemberOrder)
//    {
//        return toAjax(adamMemberOrderService.insertAdamMemberOrder(adamMemberOrder));
//    }

//    /**
//     * 修改【请填写功能名称】
//     */
//    @GetMapping("/edit/{mid}")
//    public String edit(@PathVariable("mid") String mid, ModelMap mmap)
//    {
//        AdamMemberOrder adamMemberOrder = adamMemberOrderService.selectAdamMemberOrderById(mid);
//        mmap.put("adamMemberOrder", adamMemberOrder);
//        return prefix + "/edit";
//    }
//
//    /**
//     * 修改保存【请填写功能名称】
//     */
//    @RequiresPermissions("adam:order:edit")
//    @Log(title = "【请填写功能名称】", businessType = BusinessType.UPDATE)
//    @PostMapping("/edit")
//    @ResponseBody
//    public AjaxResult editSave(AdamMemberOrder adamMemberOrder)
//    {
//        return toAjax(adamMemberOrderService.updateAdamMemberOrder(adamMemberOrder));
//    }
//
//    /**
//     * 删除【请填写功能名称】
//     */
//    @RequiresPermissions("adam:order:remove")
//    @Log(title = "【请填写功能名称】", businessType = BusinessType.DELETE)
//    @PostMapping( "/remove")
//    @ResponseBody
//    public AjaxResult remove(String ids)
//    {
//        return toAjax(adamMemberOrderService.deleteAdamMemberOrderByIds(ids));
//    }
}
