package com.liquidnet.client.admin.web.controller.zhengzai.adam;

import com.liquidnet.common.cache.redis.util.RedisUtil;
import com.liquidnet.service.adam.constant.AdamRedisConst;
import com.liquidnet.service.base.ResponseDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.validation.constraints.Max;
import javax.validation.constraints.Min;

@Api(tags = "ADAM配置")
@Slf4j
@Validated
@RestController
@RequestMapping("adam/switch")
public class AdamSwitchAdminController {
    @Autowired
    RedisUtil redisUtil;

    @RequiresPermissions("adam:switch:buy:member")
    @ApiOperation(value = "开放/限制购买会员")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", required = true, dataType = "int", name = "opt", value = "0-限制｜1-开放", example = "0"),
    })
    @PostMapping("buy/member")
    public ResponseDto<Object> purchaseSwitch(@Max(1) @Min(0) @RequestParam int opt) {
        redisUtil.set(AdamRedisConst.SWITCH_BUY_MEMBER, opt);
        return ResponseDto.success(redisUtil.get(AdamRedisConst.SWITCH_BUY_MEMBER));
    }

    @RequiresPermissions("adam:switch:max:memberno")
    @ApiOperation(value = "会员用户最大ID_NO")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", required = true, dataType = "int", name = "opt", value = "会员用户最大ID_NO", example = "15000"),
    })
    @PostMapping("set/memberno")
    public ResponseDto<Object> purchaseStartMemberNo(@Max(1) @Min(0) @RequestParam int opt) {
        redisUtil.set(AdamRedisConst.INCR_MEMBER_NO, opt);
        return ResponseDto.success(redisUtil.get(AdamRedisConst.INCR_MEMBER_NO));
    }

    @RequiresPermissions("adam:switch:gray:login")
    @ApiOperation(value = "开放/限制校验证码")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", required = true, dataType = "int", name = "opt", value = "0-限制｜1-开放", example = "0"),
    })
    @PostMapping("gray/login")
    public ResponseDto<Object> loginSmsSwitch(@Max(1) @Min(0) @RequestParam int opt) {
        redisUtil.set(AdamRedisConst.SWITCH_GRAY_LOGIN_SMS, 0 == opt ? 612543 : 615243);
        return ResponseDto.success(redisUtil.get(AdamRedisConst.SWITCH_GRAY_LOGIN_SMS));
    }
}
