package com.liquidnet.service.service.impl;

import com.liquidnet.commons.lang.util.CollectionUtil;
import com.liquidnet.service.base.SqlMapping;
import com.liquidnet.service.base.constant.MQConst;
import com.liquidnet.service.goblin.dto.vo.SmileSellDataDetailVO;
import com.liquidnet.service.goblin.dto.vo.SmileUserVO;
import com.liquidnet.service.goblin.service.manage.SmileFrontService;
import com.liquidnet.service.kylin.dto.vo.mongo.KylinPerformanceVo;
import com.liquidnet.service.util.ObjectUtil;
import com.liquidnet.service.util.QueueUtils;
import com.liquidnet.service.util.SmileMongoUtils;
import com.liquidnet.service.util.SmileRedisUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;

import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

@Service
@Slf4j
public class SmileFrontServiceImpl implements SmileFrontService {
    @Autowired
    private SmileMongoUtils smileMongoUtils;
    @Autowired
    private SmileRedisUtils smileRedisUtils;
    @Autowired
    QueueUtils queueUtils;
    @Autowired
    private MongoTemplate mongoTemplate;
    public boolean saveOrUpdateUser(SmileUserVO smileUserVO,SmileUserVO redisVo,String type){
        //redis里面更新
        if(null==redisVo){
            smileUserVO.setCreatedDate(LocalDateTime.now());
            smileUserVO.setDelTag(0);
            smileRedisUtils.setSmileUserVo(smileUserVO.getUid(),smileUserVO);
           /// insertUser(smileUserVO);
            //插入
        }else{
            //update
            setUser(smileUserVO,redisVo,type);
            smileRedisUtils.setSmileUserVo(redisVo.getUid(),redisVo);
            //updateUser(smileUserVO);
        }
        return true;
    }
    public void insertUser(SmileUserVO smileUserVO){
        smileUserVO.setType(0);
        LinkedList<String> sqls = CollectionUtil.linkedListString();
        sqls.add(SqlMapping.get("smile_service.insert_user"));
        LinkedList<Object[]> sqlData = CollectionUtil.linkedListObjectArr();
        sqlData.add(new Object[]{
                smileUserVO.getImg(),smileUserVO.getName(),smileUserVO.getUid(),smileUserVO.getBirthday(),smileUserVO.getSex(),
                smileUserVO.getPhone(),smileUserVO.getProvinceId(),smileUserVO.getProvince(),smileUserVO.getProvinceId(),smileUserVO.getCity(),
                smileUserVO.getAreaId(),smileUserVO.getArea(),smileUserVO.getAddress(),smileUserVO.getWechat(),smileUserVO.getType(),smileUserVO.getOrgId(),
                smileUserVO.getIdCard(),smileUserVO.getSchoolName(),smileUserVO.getSchoolMajor(),smileUserVO.getIdentity(),smileUserVO.getTag(),smileUserVO.getAgent(),
                smileUserVO.getErrorReason(),smileUserVO.getIntroduce(),smileUserVO.getSpecialty1(),smileUserVO.getSpecialty2(),
                smileUserVO.getSpecialty3(),0,smileUserVO.getDelTag(),smileUserVO.getCreatedDate(),smileUserVO.getUpdatedDate(),smileUserVO.getSchoolId()

        });
        String sqlDatas = SqlMapping.gets(sqls, sqlData);
        queueUtils.sendMsgByRedis(MQConst.SmileQueue.SMILE_USER.getKey(), sqlDatas);
    }
 /*   public void updateUser(SmileUserVO smileUserVO){
        LinkedList<String> sqls = CollectionUtil.linkedListString();
        sqls.add(SqlMapping.get("smile_service.update_user"));
        LinkedList<Object[]> sqlData = CollectionUtil.linkedListObjectArr();
        sqlData.add(new Object[]{
                smileUserVO.getImg(),smileUserVO.getName(),smileUserVO.getBirthday(),smileUserVO.getSex(),
                smileUserVO.getPhone(),smileUserVO.getProvinceKey(),smileUserVO.getProvince(),smileUserVO.getCityKey(),smileUserVO.getCity(),
                smileUserVO.getAreaKey(),smileUserVO.getArea(),smileUserVO.getAddress(),smileUserVO.getWechat(),smileUserVO.getType(),smileUserVO.getOrgId(),
                smileUserVO.getIdCard(),smileUserVO.getSchoolName(),smileUserVO.getSchoolMajor(),smileUserVO.getIdentity(),smileUserVO.getTag(),smileUserVO.getAgent(),
                smileUserVO.getAuthTag(),smileUserVO.getErrorReason(),smileUserVO.getIntroduce(),smileUserVO.getSpecialty1(),smileUserVO.getSpecialty2(),
                smileUserVO.getSpecialty3(),smileUserVO.getState(),smileUserVO.getUpdatedDate(),smileUserVO.getSchoolId(),smileUserVO.getUid()

        });
        String sqlDatas = SqlMapping.gets(sqls, sqlData);
        queueUtils.sendMsgByRedis(MQConst.SmileQueue.SMILE_USER.getKey(), sqlDatas);
    }*/

    public List<KylinPerformanceVo>  getPerformance(){
        ArrayList<KylinPerformanceVo> list= ObjectUtil.kylinPerformanceVoList();
      /*  List<String> list1= (List<String>) redisUtil.get(SmileRedisConst.SMILE_SHOW);
        for(String s:list1){
            KylinPerformanceVo kylinPerformanceVo=smileMongoUtils.getPerFormance(s);
            if(null!=kylinPerformanceVo){
                list.add(kylinPerformanceVo);
            }
        }*/
        String perforManceIds= smileRedisUtils.getSmileShow();
        if(StringUtils.isNotBlank(perforManceIds)){
            for(String id:perforManceIds.split(",")){
                KylinPerformanceVo kylinPerformanceVo=smileMongoUtils.getPerFormance(id);
                if(null!=kylinPerformanceVo){
                    list.add(kylinPerformanceVo);
                }
            }
        }
        return list;
    }

    @Override
    public void deleteUser(String uid) {
        LinkedList<String> sqls = CollectionUtil.linkedListString();
        sqls.add(SqlMapping.get("smile_service.delete_user"));
        LinkedList<Object[]> sqlData = CollectionUtil.linkedListObjectArr();
        sqlData.add(new Object[]{
                uid
        });
        String sqlDatas = SqlMapping.gets(sqls, sqlData);
        queueUtils.sendMsgByRedis(MQConst.SmileQueue.SMILE_USER.getKey(), sqlDatas);
    }

    @Override
    public boolean auth(String uid,SmileUserVO redisVo) {
        insertUser(redisVo);
        return true;
    }

    @Override
    public SmileSellDataDetailVO getSellDataDetail(String agentId, String ticketId, String activeName, String ticketName) {
        SmileSellDataDetailVO smileSellDataDetailVO = mongoTemplate.findOne(Query.query(Criteria.where("dataId").is(agentId+ticketId)),
                SmileSellDataDetailVO.class, SmileSellDataDetailVO.class.getSimpleName());
        //把手机变为  ***
        // 计算票的总量
        List<Map> list= smileSellDataDetailVO.getList();
        int number=0;
        for(Map a:list){
            String mobile=a.get("mobile")==null?"":a.get("mobile").toString();
            if(StringUtils.isNotBlank(mobile)){
                mobile=mobile.substring(0, 3) + "****" + mobile.substring(7, mobile.length());
                a.replace("mobile",mobile);
            }
            int d= a.get("number")==null?0:Integer.parseInt(a.get("number").toString());
            number=number + d;
            if(null!=a.get("createTime")){
                String strDateFormat = "yyyy-MM-dd HH:mm:ss";
                SimpleDateFormat sdf = new SimpleDateFormat(strDateFormat);
                a.replace("createTime",sdf.format(a.get("createTime")));
            }

        }
        smileSellDataDetailVO.setCount(number);
        smileSellDataDetailVO.setActiveName(activeName);
        smileSellDataDetailVO.setTicketName(ticketName);
        return smileSellDataDetailVO;
    }


    public void setUser(SmileUserVO smileUserVO,SmileUserVO redisVo,String type){
        if(type.equals("1")){
            redisVo.setImg(smileUserVO.getImg());
            redisVo.setSex(smileUserVO.getSex());
            redisVo.setProvinceId(smileUserVO.getProvinceId());
            redisVo.setProvince(smileUserVO.getProvince());
            redisVo.setCity(smileUserVO.getCity());
            redisVo.setCityId(smileUserVO.getCityId());
            redisVo.setArea(smileUserVO.getArea());
            redisVo.setAreaId(smileUserVO.getAreaId());
            redisVo.setAddress(smileUserVO.getAddress());
            redisVo.setWechat(smileUserVO.getWechat());
            redisVo.setSchoolName(smileUserVO.getSchoolName());
            redisVo.setSchoolId(smileUserVO.getSchoolId());
            redisVo.setSchoolMajor(smileUserVO.getSchoolMajor());
            redisVo.setIdentity(smileUserVO.getIdentity());
            redisVo.setTag(smileUserVO.getTag());
            redisVo.setUpdatedDate(LocalDateTime.now());
            redisVo.setUid(smileUserVO.getUid());
            redisVo.setDelTag(0);
            redisVo.setPhone(smileUserVO.getPhone());
            redisVo.setBirthday(smileUserVO.getBirthday());
          //  redisVo.setType(smileUserVO.getType());
        }else if (type.equals("2")){
            redisVo.setName(smileUserVO.getName());
            redisVo.setIdCard(smileUserVO.getIdCard());
            redisVo.setUpdatedDate(LocalDateTime.now());
            redisVo.setUid(smileUserVO.getUid());
            redisVo.setDelTag(0);
            //redisVo.setType(smileUserVO.getType());
        }else if(type.equals("3")){
            redisVo.setIntroduce(smileUserVO.getIntroduce());
            redisVo.setSpecialty1(smileUserVO.getSpecialty1());
            redisVo.setSpecialty2(smileUserVO.getSpecialty2());
            redisVo.setSpecialty3(smileUserVO.getSpecialty2());
            redisVo.setUpdatedDate(LocalDateTime.now());
            redisVo.setUid(smileUserVO.getUid());
            redisVo.setDelTag(0);
            //redisVo.setType(smileUserVO.getType());
        }
    }

    public static void main(String[] args) {

    }


}
