package com.liquidnet.service.goblin.dto.manage;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.DecimalMin;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import java.io.Serializable;
import java.math.BigDecimal;

@ApiModel(value = "GoblinStoreMgtCouponTypeParam", description = "商铺活动:添加优惠券:卡券类型入参")
@Data
public class GoblinStoreMgtCouponAddType implements Serializable {
    private static final long serialVersionUID = 1851062573283411594L;
    @ApiModelProperty(position = 10, required = true, value = "券类型[1-代金券|2-折扣券|3-满减券]", allowableValues = "1,2,3")
    @NotNull(message = "券类型不能为空")
    @Pattern(regexp = "\\b(1|2|3)\\b", message = "券类型参数无效")
    private String type;
    @ApiModelProperty(position = 11, required = true, value = "卡券库存，默认：0为无限")
    @NotNull(message = "卡券库存不能为空")
    @Min(value = 0, message = "卡券库存不能小于0")
    private Integer stock;
    @ApiModelProperty(position = 12, required = true, value = "触发金额[8,2]", example = "1")
    @DecimalMin(value = "0.01", message = "触发金额不能小于0.01")
    private BigDecimal triggers;

    @ApiModelProperty(position = 12, required = false, value = "面值[8,2]", example = "5")
    @DecimalMin(value = "0.01", message = "面值不能小于0.01")
    private BigDecimal valFace;
    @ApiModelProperty(position = 12, required = false, value = "折扣[8,2]", example = "0.8")
    @DecimalMin(value = "0.01", message = "折扣不能小于0.01")
    private BigDecimal discount;
    @ApiModelProperty(position = 12, required = false, value = "满减~满[8,2]", example = "10")
    @DecimalMin(value = "0.02", message = "满减金额不能小于0.02")
    private BigDecimal valOver;
    @ApiModelProperty(position = 12, required = false, value = "满减~减[8,2]", example = "5")
    @DecimalMin(value = "0.01", message = "满减面额不能小于0.01")
    private BigDecimal valMinus;
    @ApiModelProperty(position = 12, required = false, value = "抵扣上限金额[8,2]", example = "2")
    @DecimalMin(value = "0.01", message = "抵扣上限金额不能小于0.01")
    private BigDecimal deduction;
}
