package com.liquidnet.service;

import com.liquidnet.common.cache.redis.config.RedisConfig;
import lombok.extern.slf4j.Slf4j;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: TODO
 * @class: MathUtil
 * @Package com.liquidnet.common.cache.redis.util
 * @Copyright: LightNet @ Copyright (c) 2021
 * @date 2021/8/10 18:03
 */
@Slf4j
public class SweetMathUtil {
    public static int getIndex(String key){
//        log.debug("MathUtil.getIndex key:{} hashcode:{}",key,key.hashCode());
        int defaultDb = 0;
        int totalDbs = 256;
//        totalDbs = 256;
        if(totalDbs==1){
            log.info("only one db : {} ",defaultDb);
            return defaultDb;
        }
        int mod = 250;
        if(totalDbs > 1 && totalDbs < 256){
            if(totalDbs==16){
                mod = 15;
            }else{
                mod = totalDbs - 1;
            }
        }
        long value = Long.valueOf(key.hashCode());
        int hash=(int)(value ^ (value >>> 32));
        int index=hash % mod;
        log.debug("MathUtil.getIndex key:{} index:{}",key,index);
        return index;
    }

    public static void main(String[] args) {
        // 演出
//        getIndex("kylin:performances:id:3593259032328560647540949");
//        getIndex("adam:info:enters:2028906701014466564961253");
        getIndex("adam:info:certification:1450202200409261446");
//        getIndex("kylin:performances:roadShowId:5936345");
//        getIndex("kylin:performances:roadShowId:570");
















        /*getIndex("kylin:performances_inventory:ticket:id:3551230174352138247077490:surplusGeneral");288
        getIndex("kylin:performances_inventory:ticket:id:3560082202906091524013435:surplusGeneral");305
        getIndex("kylin:performances_inventory:ticket:id:3560083227952046083873656:surplusGeneral");285
        getIndex("kylin:performances_inventory:ticket:id:3560086207501721601870456:surplusGeneral");436
        getIndex("kylin:performances_inventory:ticket:id:3560170592074752006099398:surplusGeneral");54
        getIndex("kylin:performances_inventory:ticket:id:3560179412654120965327900:surplusGeneral");55
        getIndex("kylin:performances_inventory:ticket:id:3560184403037020165726408:surplusGeneral");87
        getIndex("kylin:performances_inventory:ticket:id:3560191647858319365487317:surplusGeneral");83
        getIndex("kylin:performances_inventory:ticket:id:3560224063117352965718068:surplusGeneral");93
        getIndex("kylin:performances_inventory:ticket:id:3560176911968133124045953:surplusGeneral");53
        getIndex("kylin:performances_inventory:ticket:id:3560181476922777601901633:surplusGeneral");82
        getIndex("kylin:performances_inventory:ticket:id:3560191387014553606589458:surplusGeneral");89
        getIndex("kylin:performances_inventory:ticket:id:3560085418972569601682003:surplusGeneral");300
        getIndex("kylin:performances_inventory:ticket:id:3560170163542712329786572:surplusGeneral");394
        getIndex("kylin:performances_inventory:ticket:id:3560177462051102729660448:surplusGeneral");54*/


//        getIndex("kylin:order:id:3488285488526295048358426");


//        getIndex("kylin:performances:notice");
        // 快递
//        getIndex("kylin:express:modules");
        // 订单
//        getIndex("kylin:order:coupon:id:397983761946132487870836");
//        getIndex("kylin:order:id:325244198036357120519956");
        // sweet积分活动
//        getIndex("sweet:integralActivity:prizeNum:activityId:499142611246284803622253:prizeId:499142823268352009440982");
//        getIndex("sweet:integralActivity:list");
        // sweet用户
//        getIndex("sweet:user:service:unionId:oSpYSs1NH3glVRvVLNmUKqyjxKng:type:2");
//        getIndex("sweet:user:applet:unionid:oSpYSs1NH3glVRvVLNmUKqyjxKng");
//        getIndex("sweet:user:applet:mobile:17638582147");
        // basicServices
//        getIndex("kylin:order:refund:address");
//        getIndex("basicServices:upushList:Android");

//        getIndex("basicServices:zhengzaiAppVersionsAndroid");
//        getIndex("basicServices:zhengzaiAppVersionsIos");
//        getIndex("basicServices:zhengzaiCheckAppVersionsAndroid");
//        getIndex("basicServices:zhengzaiCheckAppVersionsIos");
    }
}