package com.liquidnet.service.account.funding.service.processor;

import com.liquidnet.service.account.common.ErrorConstants;
import com.liquidnet.service.account.funding.dto.FundingQueryBalanceResult;
import com.liquidnet.service.account.funding.dto.base.FundingContextParam;
import com.liquidnet.service.account.funding.service.FinAccountBillService;
import com.liquidnet.service.account.funding.service.FundingProcessorService;
import com.liquidnet.service.account.funding.vo.FundingAccountInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * FundingQueryBalanceProcessService.class
 *
 * @author zhanggb
 * Created by IntelliJ IDEA at 2020/10/22
 */
@Service
public class FundingQueryBalanceProcessor extends FundingProcessorService {
    private static final Logger log = LoggerFactory.getLogger(FundingQueryBalanceProcessor.class);
    @Autowired
    private FinAccountBillService accountBillService;

    @Override
    public FundingQueryBalanceResult checkInputParams(FundingContextParam context) {
        if (CollectionUtils.isEmpty(context.getFinIdWithAccNoMap())) {
            return new FundingQueryBalanceResult(ErrorConstants.PARAMS_VALUE_ERROR_CODE, "Invalid finIdWithAccNoMap");
        }
        return new FundingQueryBalanceResult();
    }

    @Override
    public FundingQueryBalanceResult checkBussinessLogic(FundingContextParam context) {
        return new FundingQueryBalanceResult();
    }

    @Override
    public FundingQueryBalanceResult doBussiness(FundingContextParam context) {
        List<FundingAccountInfo> fundingAccountInfoList = new ArrayList<>();

        Set<Map.Entry<String, List<String>>> entries = context.getFinIdWithAccNoMap().entrySet();
        for (Map.Entry<String, List<String>> entry : entries) {
            List<FundingAccountInfo> list = accountBillService.queryByAccNoForGroup(entry.getKey(), entry.getValue());
            if (!CollectionUtils.isEmpty(list)) {
                fundingAccountInfoList.addAll(list);
            }
        }

        return new FundingQueryBalanceResult(fundingAccountInfoList);
    }
}
