package com.liquidnet.service.kylin.service.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.liquidnet.common.cache.redis.util.RedisUtil;
import com.liquidnet.commons.lang.util.DateUtil;
import com.liquidnet.service.kylin.dto.vo.KylinBannersVo;
import com.liquidnet.service.kylin.entity.KylinBanners;
import com.liquidnet.service.kylin.mapper.KylinBannersMapper;
import com.liquidnet.service.kylin.service.admin.IKylinBannersService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;

/**
 * <p>
 * 轮播图 服务实现类
 * </p>
 *
 * @author jiangxiulong
 * @since 2021-05-02
 */
@Service
public class BannersServiceImpl extends ServiceImpl<KylinBannersMapper, KylinBanners> implements IKylinBannersService {
    @Autowired
    MongoTemplate mongoTemplate;

    @Autowired
    RedisUtil redisUtil;

    public List blist(String position, String provinceName) {
        Query query = new Query();
        query.addCriteria(
                Criteria.where("isOnline").is(1).and("isDeleted").is(1)
        );

        LocalDateTime nowTime = LocalDateTime.now();
        String nowTimeStr = DateUtil.Formatter.yyyyMMddHHmmss.format(nowTime);
        Criteria onlineTimeBetween = Criteria.where("onlineStartTime").lte(nowTimeStr).and("onlineEndTime").gte(nowTimeStr);
        Criteria onlineTimeGt = Criteria.where("onlineStartTime").lte(nowTimeStr).and("onlineEndTime").is("");
        Criteria onlineTimeLt = Criteria.where("onlineStartTime").is("").and("onlineEndTime").gte(nowTimeStr);
        Criteria onlineTimeEmpty = Criteria.where("onlineStartTime").is("").and("onlineEndTime").is("");
        Criteria mergeCriteriaTime = new Criteria();
        mergeCriteriaTime.orOperator(onlineTimeBetween, onlineTimeGt, onlineTimeLt, onlineTimeEmpty);

        if (!position.isEmpty()) {
            query.addCriteria(
                    Criteria.where("positionList").in(position)
            );
        }

        Criteria mergeCriteriaPromotion = new Criteria();
        if (!provinceName.isEmpty()) {
            Criteria promotionCity = Criteria.where("provincesNameList").in(provinceName);
            Criteria promotionAll = Criteria.where("promotionType").is(1);
            mergeCriteriaPromotion.orOperator(promotionCity, promotionAll);
        }

        Criteria criteria = new Criteria();
        query.addCriteria(
                criteria.andOperator(mergeCriteriaTime, mergeCriteriaPromotion)
        );

        List bannerList = mongoTemplate.find(
                query,
                KylinBannersVo.class,
                KylinBannersVo.class.getSimpleName()
        );

        return bannerList;
    }

}
