package com.liquidnet.service.kylin.dto.vo.mongo;

import com.liquidnet.service.kylin.entity.KylinOrderTicketRelations;
import com.liquidnet.service.kylin.entity.KylinOrderTicketStatus;
import com.liquidnet.service.kylin.entity.KylinOrderTickets;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.beans.BeanUtils;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

@ApiModel(value = "KylinOrderTicketVo", description = "订单数据")
@Data
public class KylinOrderTicketVo implements Serializable {
    private Integer mid;
    private static final long serialVersionUID = 5325511589667456213L;
    @ApiModelProperty(position = 10, value = "ID")
    private String orderTicketsId;
    @ApiModelProperty(position = 11, value = "用户ID[64]")
    private String userId;
    @ApiModelProperty(position = 12, value = "用户昵称")
    private String userName;
    @ApiModelProperty(position = 13, value = "用户手机号")
    private String userMobile;
    @ApiModelProperty(position = 14, value = "演出名称")
    private String performanceTitle;
    private String ticketTitle;
    private String timeStart;
    private String useStart;
    private String performanceImg;
    @ApiModelProperty(position = 15, value = "订单号")
    private String orderCode;
    @ApiModelProperty(position = 16, value = "支付单号")
    private String payCode;
    @ApiModelProperty(position = 17, value = "二维码地址")
    private String qrCode;
    @ApiModelProperty(position = 18, value = "下单方式")
    private String orderType;
    @ApiModelProperty(position = 19, value = "下单版本")
    private String orderVersion;
    @ApiModelProperty(position = 20, value = "数量")
    private Integer number;
    @ApiModelProperty(position = 21, value = "单价")
    private BigDecimal price;
    @ApiModelProperty(position = 22, value = "会员单价")
    private BigDecimal priceMember;
    @ApiModelProperty(position = 23, value = "应付价格")
    private BigDecimal priceTotal;
    @ApiModelProperty(position = 24, value = "优惠价格")
    private BigDecimal priceVoucher;
    @ApiModelProperty(position = 25, value = "实付价格")
    private BigDecimal priceActual;
    @ApiModelProperty(position = 26, value = "快递价格")
    private BigDecimal priceExpress;
    @ApiModelProperty(position = 27, value = "退款价格")
    private BigDecimal priceRefund;
    @ApiModelProperty(position = 28, value = "退款张数")
    private Integer refundNumber;
    @ApiModelProperty(position = 29, value = "选择支付方式")
    private String payType;
    @ApiModelProperty(position = 30, value = "实际支付方式")
    private String paymentType;
    @ApiModelProperty(position = 31, value = "支付时间")
    private String timePay;
    @ApiModelProperty(position = 32, value = "收货人")
    private String expressContacts;
    @ApiModelProperty(position = 33, value = "收货地址")
    private String expressAddress;
    @ApiModelProperty(position = 34, value = "收货人联系方式")
    private String expressPhone;
    @ApiModelProperty(position = 35, value = "券使用类别")
    private String couponType;
    @ApiModelProperty(position = 36, value = "取票方式 电子票electronic快递票express")
    private String getTicketType;
    @ApiModelProperty(position = 37, value = "直播用取票观演码，隔开")
    private String getTicketDescribe;
    @ApiModelProperty(position = 38, value = "订单过期时间(分钟)")
    private Integer payCountdownMinute;

    private Integer expressType;
    private Integer isStudent;
    private Integer transferStatus;
    private Integer status;
    private Integer payStatus;

    private String transferId;
    private String liveId;
    private String performanceId;
    private String timeId;
    private String ticketId;
    private String agentId;
    private Integer isMember;

    private String overdueAt;
    private String createdAt;
    private String updatedAt;

//    private Integer isCanRefund;
    private Integer isHaveRefundDetails;

    private LocalDateTime changeDate;

    private Integer isTrueName;
    private String noticeImage;
    private String notice;
    private Integer ticketType;
    private String fieldName;

    private List<KylinOrderTicketEntitiesVo> entitiesVoList;

    public void setOrderTicket(KylinOrderTickets orderTicket) {
        BeanUtils.copyProperties(orderTicket,this);
    }

    public void setOrderTicketStatus(KylinOrderTicketStatus orderTicketStatus) {
        BeanUtils.copyProperties(orderTicketStatus,this);
    }

    public void setOrderTicketRelation(KylinOrderTicketRelations orderTicketRelation) {
        BeanUtils.copyProperties(orderTicketRelation,this);
    }
}
