package com.liquidnet.service.goblin.dto.vo;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 * <p>
 * 商城订单表
 * </p>
 *
 * @author liquidnet
 * @since 2021-12-27
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class GoblinNowOrderListVo implements Serializable, Cloneable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "订单id")
    private String orderId;
    @ApiModelProperty(value = "订单号")
    private String orderCode;
    @ApiModelProperty(value = "订单金额")
    private String priceActual;
    @ApiModelProperty(value = "支付时间")
    private String payTime;
    @ApiModelProperty(value = "用户id")
    private String uid;

    private static final GoblinNowOrderListVo obj = new GoblinNowOrderListVo();

    public static GoblinNowOrderListVo getNew() {
        try {
            return (GoblinNowOrderListVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new GoblinNowOrderListVo();
        }
    }
}
