package com.liquidnet.service.adam.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

@ApiModel(value = "AdamMemberOrderResult", description = "购买会员或会员码响应")
@Data
public class AdamMemberOrderResult implements Serializable, Cloneable {
    private static final long serialVersionUID = 5977054291285833952L;
    @ApiModelProperty(value = "支付CODE")
    private String code;
    @ApiModelProperty(value = "会员订单号")
    private String orderNo;
    @ApiModelProperty(value = "支付数据")
    private Object payData;
    @ApiModelProperty(value = "未支付/取消支付跳转URL")
    private String showUrl;
    @ApiModelProperty(value = "支付成功跳转URL")
    private String returnUrl;

    private static final AdamMemberOrderResult obj = new AdamMemberOrderResult();

    public static AdamMemberOrderResult getNew() {
        try {
            return (AdamMemberOrderResult) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new AdamMemberOrderResult();
        }
    }
}
