package com.liquidnet.service.kylin.utils;

import com.liquidnet.service.kylin.dto.vo.mongo.KylinOrderTicketEntitiesVo;
import io.swagger.models.auth.In;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Component;

import java.util.ArrayList;

@Component
public class OrderUtils {

    @Autowired
    private DataUtils dataUtils;

    public String judgeOrderLimit(
            int type,
            String userId,
            String idCard,
            String performanceId,
            String ticketId,
            int performanceLimitCount,
            int performanceMemberLimitCount,
            int ticketLimitCount,
            int ticketMemberLimitCount,
            int performanceBuyCount,
            int ticketBuyCount,
            int memberType,
            int isTrueName
    ) {
        Integer[] integers;
        if (103 == type) {
            integers=roadShowOrderLimit(userId,idCard,performanceId,ticketId,performanceBuyCount,ticketBuyCount,isTrueName);
        } else {
            integers=festivalOrderLimit(userId,idCard,performanceId,ticketId,performanceBuyCount,ticketBuyCount,isTrueName);
        }
        return judgeMemberType(performanceLimitCount,performanceMemberLimitCount,ticketLimitCount,ticketMemberLimitCount,memberType,integers[0],integers[1]);
    }

    public Integer[] roadShowOrderLimit(
            String userId,
            String idCard,
            String performanceId,
            String ticketId,
            int performanceBuyCount,
            int ticketBuyCount,
            int isTrueName
    ) {
        if (1 == isTrueName) {//实名
            performanceBuyCount += dataUtils.getIdCardPBuyCount(idCard, performanceId);
            ticketBuyCount += dataUtils.getIdCardTBuyCount(idCard, ticketId);
        } else {//非实名
            performanceBuyCount += dataUtils.getUserPBuyCount(userId, performanceId);
            ticketBuyCount += dataUtils.getUserTBuyCount(userId, ticketId);
        }
        return new Integer[]{performanceBuyCount,ticketBuyCount};
    }

    public Integer[] festivalOrderLimit(
            String userId,
            String idCard,
            String performanceId,
            String ticketId,
            int performanceBuyCount,
            int ticketBuyCount,
            int isTrueName
    ) {
        if (1 == isTrueName) {//实名
            performanceBuyCount += dataUtils.getUserPBuyCount(idCard, performanceId);
            ticketBuyCount += dataUtils.getUserTBuyCount(idCard, ticketId);
        } else {//非实名
            performanceBuyCount += dataUtils.getUserPBuyCount(userId, performanceId);
            ticketBuyCount += dataUtils.getUserTBuyCount(userId, ticketId);
        }

        return new Integer[]{performanceBuyCount,ticketBuyCount};
    }

    public String judgeMemberType(int performanceLimitCount, int performanceMemberLimitCount, int ticketLimitCount, int ticketMemberLimitCount, int memberType, int performanceBuyCount, int ticketBuyCount) {
        if (memberType == 1 || memberType == 2) {
            if (performanceBuyCount > performanceMemberLimitCount && performanceMemberLimitCount != 0) {
                return "该演出只能购买" + performanceMemberLimitCount + "张";//超过演出维度购买量
            }
            if (ticketBuyCount > ticketMemberLimitCount && ticketMemberLimitCount != 0) {
                return "该票种只能购买" + ticketMemberLimitCount + "张";//超过票维度购买量
            }
        } else {//非会员区间
            if (performanceBuyCount > performanceLimitCount && performanceLimitCount != 0) {
                return "该演出只能购买" + performanceLimitCount + "张";//超过演出维度购买量
            }
            if (ticketBuyCount > ticketLimitCount && ticketLimitCount != 0) {
                return "该票种只能购买" + ticketLimitCount + "张";//超过票维度购买量
            }
        }
        return "";
    }

}
