package com.liquidnet.service.kylin.constant;

/**
 * 演出状态文案
 */
public enum KylinPerformanceStatusEnum {
    PERFORMANCESTATUS6("购买", 6),
    PERFORMANCESTATUS7("已下架", 7),
    PERFORMANCESTATUS8("售馨", 8),
    PERFORMANCESTATUS9("未开始", 9),
    PERFORMANCESTATUS10("已结束", 10);

    // 成员变量
    private String name;
    private int index;

    private KylinPerformanceStatusEnum(String name, int index) {
        this.name = name;
        this.index = index;
    }

    public int getIndex() {
        return index;
    }

    public static String getName(int index) {
        for (KylinPerformanceStatusEnum c : KylinPerformanceStatusEnum.values()) {
            if (c.getIndex() == index) {
                return c.name;
            }
        }
        return null;
    }
}
