package com.liquidnet.service.sweet.controller;

import com.liquidnet.commons.lang.util.CollectionUtil;
import com.liquidnet.commons.lang.util.IDGenerator;
import com.liquidnet.commons.lang.util.StringUtil;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.base.SqlMapping;
import com.liquidnet.service.base.constant.MQConst;
import com.liquidnet.service.sweet.service.impl.SweetTestImpl;
import com.liquidnet.service.sweet.utils.QueueUtils;
import com.liquidnet.service.sweet.utils.WechatUsersRedisUtils;
import com.liquidnet.service.sweet.vo.SweetMaoDengVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.LinkedList;

@Api(tags = "活动-猫登活动")
@RestController
@RequestMapping("/wechatMaoDeng")
@Slf4j
public class SweetWechatMaoDengController {

    @Autowired
    private WechatUsersRedisUtils redisUtils;
    @Autowired
    QueueUtils queueUtils;

    @GetMapping("/backData")
    @ApiOperation("返回文字图片")
    public ResponseDto<SweetMaoDengVo> backDatas(String userId){


        SweetMaoDengVo sweetMaoDeng = redisUtils.getSweetMaoDengText(userId);
        String textMsg = sweetMaoDeng.getTextMsg();
        String image = sweetMaoDeng.getPicUrl();
        if (StringUtil.isEmpty(textMsg) && StringUtil.isEmpty(image)) {
            return ResponseDto.failure("90081", "获取信息失败");
        }

        return ResponseDto.success(sweetMaoDeng);
    }

    @PostMapping("/backData")
    @ApiOperation("存生成的图")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "query", dataType = "String", name = "userId", value = "userId"),
            @ApiImplicitParam(type = "query", dataType = "String", name = "imgUrl", value = "imgUrl"),
            @ApiImplicitParam(type = "query", dataType = "String", name = "maoId", value = "maoId"),
    })
    public ResponseDto addBuilderImg(@RequestParam(value = "userId",required = false) String userId,
                                     @RequestParam(value = "imgUrl",required = false)String imgUrl,
                                     @RequestParam(value = "maoId",required = false)String maoId){
        //redis队列入库
        LinkedList<String> sqls = CollectionUtil.linkedListString();
        LinkedList<Object[]> sqlsDataA = CollectionUtil.linkedListObjectArr();
        sqls.add(SqlMapping.get("sweet_wechat_maodeng.insert_img"));
        sqlsDataA.add(new Object[]{imgUrl,userId,maoId});
        queueUtils.sendMsgByRedis(MQConst.SweetQueue.SWEET_WECHAT_MAODENG_TEXT_INSERT.getKey(), SqlMapping.gets(sqls, sqlsDataA));
        return ResponseDto.success();
    }



}
